"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _navigation = require("@kbn/security-solution-navigation/src/navigation");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../pages/translations");
var _routing = require("../../management/common/routing");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cases/attachments/external_reference_event.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AttachmentContentEvent = ({
  externalReferenceMetadata: {
    command,
    targets
  }
}) => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _navigation.useNavigation)();
  const endpointDetailsHref = getAppUrl({
    path: (0, _routing.getEndpointDetailsPath)({
      name: 'endpointActivityLog',
      selected_endpoint: targets[0].endpointId
    })
  });
  const hostsDetailsHref = getAppUrl({
    path: `/hosts/name/${targets[0].hostname}`
  });
  const actionText = (0, _react.useMemo)(() => {
    return command === 'isolate' ? `${_translations.ISOLATED_HOST} ` : `${_translations.RELEASED_HOST} `;
  }, [command]);
  const linkHref = (0, _react.useMemo)(() => targets[0].agentType === 'endpoint' ? endpointDetailsHref : hostsDetailsHref, [endpointDetailsHref, hostsDetailsHref, targets]);
  const onLinkClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    return navigateTo({
      url: linkHref
    });
  }, [navigateTo, linkHref]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actionText, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onLinkClick,
    href: linkHref,
    "data-test-subj": `actions-link-${targets[0].endpointId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, targets[0].hostname), targets.length > 1 && (0, _translations.OTHER_ENDPOINTS)(targets.length - 1));
};

// eslint-disable-next-line import/no-default-export
exports.default = AttachmentContentEvent;
module.exports = exports.default;