"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSelection = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _elastic_llm = require("@kbn/elastic-assistant/impl/tour/elastic_llm");
var _react2 = require("@emotion/react");
var _const = require("@kbn/elastic-assistant/impl/tour/const");
var _alert_selection_query = require("./alert_selection_query");
var _alert_selection_range = require("./alert_selection_range");
var _get_max_alerts = require("./helpers/get_max_alerts");
var _get_tabs = require("./helpers/get_tabs");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/alert_selection/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertSelectionComponent = ({
  alertsPreviewStackBy0,
  alertSummaryStackBy0,
  filterManager,
  onSettingsChanged,
  settings,
  setAlertsPreviewStackBy0,
  setAlertSummaryStackBy0,
  showConnectorSelector,
  connectorId,
  onConnectorIdSelected
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const tabs = (0, _react.useMemo)(() => (0, _get_tabs.getTabs)({
    alertsPreviewStackBy0,
    alertSummaryStackBy0,
    settings,
    setAlertsPreviewStackBy0,
    setAlertSummaryStackBy0
  }), [alertsPreviewStackBy0, alertSummaryStackBy0, settings, setAlertsPreviewStackBy0, setAlertSummaryStackBy0]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(tabs[0].id);
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const onMaxAlertsChanged = (0, _react.useCallback)(value => {
    const maxAlerts = (0, _get_max_alerts.getMaxAlerts)(value);
    onSettingsChanged === null || onSettingsChanged === void 0 ? void 0 : onSettingsChanged({
      ...settings,
      size: maxAlerts
    });
  }, [onSettingsChanged, settings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "alertSelection",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, showConnectorSelector && spaceId && /*#__PURE__*/_react.default.createElement(_elasticAssistant.AssistantSpaceIdProvider, {
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "customizeAlerts",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, i18n.CUSTOMIZE_THE_CONNECTOR_AND_ALERTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_elastic_llm.ElasticLLMCostAwarenessTour, {
    isDisabled: false,
    wrapper: false,
    selectedConnectorId: connectorId,
    storageKey: _const.NEW_FEATURES_TOUR_STORAGE_KEYS.ELASTIC_LLM_USAGE_ATTACK_DISCOVERY_FLYOUT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.CONNECTOR,
    css: (0, _react2.css)`
                flex-grow: 1;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.ConnectorSelectorInline, {
    fullWidth: true,
    onConnectorSelected: _fp.noop,
    onConnectorIdSelected: onConnectorIdSelected,
    selectedConnectorId: connectorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.CUSTOM_QUERY,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_selection_query.AlertSelectionQuery, {
    filterManager: filterManager,
    settings: settings,
    onSettingsChanged: onSettingsChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.SET_NUMBER_OF_ALERTS_TO_ANALYZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_selection_range.AlertSelectionRange, {
    maxAlerts: settings.size,
    setMaxAlerts: onMaxAlertsChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "tabs",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    isSelected: tab.id === selectedTabId,
    onClick: () => setSelectedTabId(tab.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  }, tab.name))), selectedTabContent);
};
AlertSelectionComponent.displayName = 'AlertSelection';
const AlertSelection = exports.AlertSelection = /*#__PURE__*/_react.default.memo(AlertSelectionComponent);