"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupWrapperLoading = exports.GroupWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/grouping/asset_inventory_grouping.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ASSET_INVENTORY_TEST_SUBJECTS = {
  grouping: _constants.TEST_SUBJ_GROUPING,
  groupingLoading: _constants.TEST_SUBJ_GROUPING_LOADING
};

/**
 * This component is used to render the loading state of the AssetInventoryGrouping component
 * It's used to avoid the flickering of the table when the data is loading
 */
const GroupWrapperLoading = ({
  grouping,
  pageSize
}) => {
  return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.GroupWrapperLoading, {
    grouping: grouping,
    pageSize: pageSize,
    testSubjects: ASSET_INVENTORY_TEST_SUBJECTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
};
exports.GroupWrapperLoading = GroupWrapperLoading;
const GroupWrapper = ({
  data,
  renderChildComponent,
  grouping,
  activePageIndex,
  isFetching,
  pageSize,
  onChangeGroupsItemsPerPage,
  onChangeGroupsPage,
  selectedGroup,
  groupingLevel = 0,
  groupSelectorComponent
}) => {
  return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.GroupWrapper, {
    data: data,
    renderChildComponent: renderChildComponent,
    grouping: grouping,
    activePageIndex: activePageIndex,
    isFetching: isFetching,
    pageSize: pageSize,
    onChangeGroupsItemsPerPage: onChangeGroupsItemsPerPage,
    onChangeGroupsPage: onChangeGroupsPage,
    selectedGroup: selectedGroup,
    groupingLevel: groupingLevel,
    groupSelectorComponent: groupSelectorComponent,
    testSubjects: ASSET_INVENTORY_TEST_SUBJECTS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  });
};
exports.GroupWrapper = GroupWrapper;