"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventoryDataTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n = require("@kbn/i18n");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _cellActions = require("@kbn/cell-actions");
var _discoverUtils = require("@kbn/discover-utils");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _helpers = require("../../common/lib/cell_actions/helpers");
var _kibana = require("../../common/lib/kibana");
var _asset_criticality_badge = require("../../entity_analytics/components/asset_criticality/asset_criticality_badge");
var _additional_controls = require("./additional_controls");
var _risk_badge = require("./risk_badge");
var _asset_inventory_empty_state = require("./asset_inventory_empty_state");
var _use_dynamic_entity_flyout = require("../hooks/use_dynamic_entity_flyout");
var _data_view_context = require("../hooks/data_view_context");
var _use_styles = require("../hooks/use_styles");
var _use_fetch_grid_data = require("../hooks/use_fetch_grid_data");
var _constants = require("../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/asset_inventory/components/asset_inventory_data_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const gridStyle = {
  border: 'horizontal',
  cellPadding: 'l',
  stripes: false,
  header: 'underline'
};
const title = _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.tableRowTypeLabel', {
  defaultMessage: 'assets'
});
const columnHeaders = {
  [_constants.ASSET_FIELDS.ENTITY_NAME]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.name', {
    defaultMessage: 'Name'
  }),
  [_constants.ASSET_FIELDS.ENTITY_ID]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.id', {
    defaultMessage: 'ID'
  }),
  [_constants.ASSET_FIELDS.ENTITY_TYPE]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.type', {
    defaultMessage: 'Type'
  }),
  [_constants.ASSET_FIELDS.TIMESTAMP]: _i18n.i18n.translate('xpack.securitySolution.assetInventory.allAssets.lastSeen', {
    defaultMessage: 'Last Seen'
  })
};
const customCellRenderer = rows => ({
  [_constants.ASSET_FIELDS.ENTITY_RISK]: ({
    rowIndex
  }) => {
    const risk = rows[rowIndex].flattened[_constants.ASSET_FIELDS.ENTITY_RISK];
    return /*#__PURE__*/_react.default.createElement(_risk_badge.RiskBadge, {
      risk: risk,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 12
      }
    });
  },
  [_constants.ASSET_FIELDS.ASSET_CRITICALITY]: ({
    rowIndex
  }) => {
    const criticality = rows[rowIndex].flattened[_constants.ASSET_FIELDS.ASSET_CRITICALITY];
    return /*#__PURE__*/_react.default.createElement(_asset_criticality_badge.AssetCriticalityBadge, {
      criticalityLevel: criticality === 'deleted' ? 'unassigned' : criticality,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    });
  }
});
const defaultColumns = [{
  id: _constants.ASSET_FIELDS.ENTITY_NAME,
  width: 400
}, {
  id: _constants.ASSET_FIELDS.ENTITY_ID
}, {
  id: _constants.ASSET_FIELDS.ENTITY_TYPE
}, {
  id: _constants.ASSET_FIELDS.TIMESTAMP
}];
const AssetInventoryDataTable = ({
  state,
  height,
  groupSelectorComponent
}) => {
  const {
    pageSize,
    sort,
    query,
    queryError,
    getRowsFromPages,
    onChangeItemsPerPage,
    onResetFilters,
    onSort,
    setUrlQuery
  } = state;

  // Table Flyout Controls -------------------------------------------------------------------

  const [expandedDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const {
    openDynamicFlyout,
    closeDynamicFlyout
  } = (0, _use_dynamic_entity_flyout.useDynamicEntityFlyout)({
    onFlyoutClose: () => setExpandedDoc(undefined)
  });
  const openTableFlyout = doc => {
    if (doc && doc.raw._source) {
      var _source$entity, _source$entity$Engine, _source$entity2;
      const source = doc.raw._source;
      setExpandedDoc(doc); // Table is expecting the same doc ref to highlight the selected row
      openDynamicFlyout({
        entityDocId: doc.raw._id,
        entityType: (_source$entity = source.entity) === null || _source$entity === void 0 ? void 0 : (_source$entity$Engine = _source$entity.EngineMetadata) === null || _source$entity$Engine === void 0 ? void 0 : _source$entity$Engine.Type,
        entityName: (_source$entity2 = source.entity) === null || _source$entity2 === void 0 ? void 0 : _source$entity2.name,
        scopeId: _constants.ASSET_INVENTORY_TABLE_ID,
        contextId: _constants.ASSET_INVENTORY_TABLE_ID
      });
    } else {
      closeDynamicFlyout();
      setExpandedDoc(undefined);
    }
  };

  // -----------------------------------------------------------------------------------------

  const {
    data: rowsData,
    fetchNextPage: loadMore,
    isFetching: isFetchingGridData,
    isLoading: isLoadingGridData
  } = (0, _use_fetch_grid_data.useFetchGridData)({
    query,
    sort,
    enabled: !queryError,
    pageSize: _constants.DEFAULT_VISIBLE_ROWS_PER_PAGE
  });
  const rows = getRowsFromPages(rowsData === null || rowsData === void 0 ? void 0 : rowsData.pages);
  const totalHits = (rowsData === null || rowsData === void 0 ? void 0 : rowsData.pages[0].total) || 0;
  const [localStorageColumns, setLocalStorageColumns] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_COLUMNS_KEY, defaultColumns.map(c => c.id));
  const [persistedSettings, setPersistedSettings] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_COLUMNS_SETTINGS_KEY, {
    columns: defaultColumns.reduce((columnSettings, column) => {
      const columnDefaultSettings = column.width ? {
        width: column.width
      } : {};
      const newColumn = {
        [column.id]: columnDefaultSettings
      };
      return {
        ...columnSettings,
        ...newColumn
      };
    }, {})
  });
  const settings = (0, _react.useMemo)(() => {
    return {
      columns: Object.keys(persistedSettings === null || persistedSettings === void 0 ? void 0 : persistedSettings.columns).reduce((columnSettings, columnId) => {
        var _persistedSettings$co;
        const newColumn = {
          ..._lodash.default.pick(persistedSettings === null || persistedSettings === void 0 ? void 0 : (_persistedSettings$co = persistedSettings.columns) === null || _persistedSettings$co === void 0 ? void 0 : _persistedSettings$co[columnId], ['width']),
          display: columnHeaders === null || columnHeaders === void 0 ? void 0 : columnHeaders[columnId]
        };
        return {
          ...columnSettings,
          [columnId]: newColumn
        };
      }, {})
    };
  }, [persistedSettings]);
  const {
    dataView,
    dataViewIsLoading
  } = (0, _data_view_context.useDataViewContext)();
  const {
    uiActions,
    uiSettings,
    dataViews,
    data,
    application: {
      capabilities
    },
    theme,
    fieldFormats,
    notifications,
    storage
  } = (0, _kibana.useKibana)().services;
  const {
    filterManager
  } = data.query;
  const services = {
    theme,
    fieldFormats,
    uiSettings,
    toastNotifications: notifications.toasts,
    storage,
    data
  };
  const styles = (0, _use_styles.useStyles)();
  const {
    columns: currentColumns,
    onSetColumns,
    onAddColumn,
    onRemoveColumn
  } = (0, _unifiedDataTable.useColumns)({
    capabilities,
    defaultOrder: uiSettings.get(_discoverUtils.SORT_DEFAULT_ORDER_SETTING),
    dataView,
    dataViews,
    setAppState: props => setLocalStorageColumns(props.columns),
    columns: localStorageColumns,
    sort
  });

  /**
   * This object is used to determine if the table rendering will be virtualized and the virtualization wrapper height.
   * mode should be passed as a key to the UnifiedDataTable component to force a re-render when the mode changes.
   */
  const computeDataTableRendering = (0, _react.useMemo)(() => {
    // Enable virtualization mode when the table is set to a large page size.
    const isVirtualizationEnabled = pageSize >= 100;
    const getWrapperHeight = () => {
      if (height) return height;

      // If virtualization is not needed the table will render unconstrained.
      if (!isVirtualizationEnabled) return 'auto';
      const baseHeight = 362; // height of Kibana Header + Findings page header and search bar
      return `calc(100vh - ${baseHeight}px)`;
    };
    return {
      wrapperHeight: getWrapperHeight(),
      mode: isVirtualizationEnabled ? 'virtualized' : 'standard'
    };
  }, [pageSize, height]);
  const onAddFilter = (0, _react.useMemo)(() => filterManager && dataView ? (clickedField, values, operation) => {
    const newFilters = (0, _public.generateFilters)(filterManager, clickedField, values, operation, dataView);
    filterManager.addFilters(newFilters);
    setUrlQuery({
      filters: filterManager.getFilters()
    });
  } : undefined, [dataView, filterManager, setUrlQuery]);
  const onResize = colSettings => {
    const grid = persistedSettings || {};
    const newColumns = {
      ...(grid.columns || {})
    };
    newColumns[colSettings.columnId] = colSettings.width ? {
      width: Math.round(colSettings.width)
    } : {};
    const newGrid = {
      ...grid,
      columns: newColumns
    };
    setPersistedSettings(newGrid);
  };
  const externalCustomRenderers = (0, _react.useMemo)(() => customCellRenderer(rows), [rows]);
  const onResetColumns = () => {
    setLocalStorageColumns(defaultColumns.map(c => c.id));
  };
  const handleAddColumn = columnId => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_COLUMN_ADDED, _ui_metrics.ASSET_INVENTORY_APP_NAME);
    onAddColumn(columnId);
  };
  const handleRemoveColumn = columnId => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ASSET_INVENTORY_COLUMN_REMOVED, _ui_metrics.ASSET_INVENTORY_APP_NAME);
    onRemoveColumn(columnId);
  };
  const externalAdditionalControls = /*#__PURE__*/_react.default.createElement(_additional_controls.AdditionalControls, {
    total: totalHits,
    title: title,
    columns: currentColumns,
    onAddColumn: handleAddColumn,
    onRemoveColumn: handleRemoveColumn,
    onResetColumns: onResetColumns,
    groupSelectorComponent: groupSelectorComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 5
    }
  });
  const loadingState = isLoadingGridData ? _unifiedDataTable.DataLoadingState.loading : _unifiedDataTable.DataLoadingState.loaded;
  return /*#__PURE__*/_react.default.createElement(_cellActions.CellActionsProvider, {
    getTriggerCompatibleActions: uiActions.getTriggerCompatibleActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _constants.TEST_SUBJ_DATA_GRID,
    className: styles.gridContainer,
    style: {
      height: computeDataTableRendering.wrapperHeight
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    css: {
      opacity: isFetchingGridData ? 1 : 0
    },
    className: styles.gridProgressBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 9
    }
  }), dataViewIsLoading ? null : loadingState === _unifiedDataTable.DataLoadingState.loaded && totalHits === 0 ? /*#__PURE__*/_react.default.createElement(_asset_inventory_empty_state.AssetInventoryEmptyState, {
    onResetFilters: onResetFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTable, {
    key: computeDataTableRendering.mode,
    className: styles.gridStyle,
    ariaLabelledBy: title,
    columns: currentColumns,
    dataView: dataView,
    loadingState: loadingState,
    onFilter: onAddFilter,
    onResize: onResize,
    onSetColumns: onSetColumns,
    onSort: onSort,
    rows: rows,
    sampleSizeState: _constants.MAX_ASSETS_TO_LOAD,
    expandedDoc: expandedDoc,
    setExpandedDoc: openTableFlyout,
    renderDocumentView: _helpers.EmptyComponent,
    sort: sort,
    rowsPerPageState: pageSize,
    totalHits: totalHits,
    services: services,
    onUpdateRowsPerPage: onChangeItemsPerPage,
    rowHeightState: 0,
    showMultiFields: uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    showTimeCol: false,
    settings: settings,
    onFetchMoreRecords: loadMore,
    externalCustomRenderers: externalCustomRenderers,
    externalAdditionalControls: externalAdditionalControls,
    gridStyleOverride: gridStyle,
    rowLineHeightOverride: "24px",
    dataGridDensityState: _unifiedDataTable.DataGridDensity.EXPANDED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 11
    }
  })));
};
exports.AssetInventoryDataTable = AssetInventoryDataTable;