"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterPrivilegesForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _remote_clusters_combo_box = require("./remote_clusters_combo_box");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/remote_cluster_privileges_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fromOption = option => option.label;
const toOption = value => ({
  label: value
});
const RemoteClusterPrivilegesForm = ({
  isRoleReadOnly,
  remoteClusters = [],
  formIndex,
  validator,
  remoteClusterPrivilege,
  availableRemoteClusterPrivileges,
  onChange,
  onDelete
}) => {
  var _ref2;
  const onCreateClusterOption = (0, _react2.useCallback)(option => {
    var _ref;
    // @ts-expect-error upgrade typescript v5.9.3
    const nextClusters = ((_ref = [...remoteClusterPrivilege.clusters]) !== null && _ref !== void 0 ? _ref : []).concat([option]);
    onChange({
      ...remoteClusterPrivilege,
      clusters: nextClusters
    });
  }, [remoteClusterPrivilege, onChange]);
  const onClustersChange = (0, _react2.useCallback)(nextOptions => {
    const clusters = nextOptions.map(fromOption);
    onChange({
      ...remoteClusterPrivilege,
      clusters
    });
  }, [onChange, remoteClusterPrivilege]);
  const onPrivilegeChange = (0, _react2.useCallback)(newPrivileges => {
    onChange({
      ...remoteClusterPrivilege,
      privileges: newPrivileges.map(fromOption)
    });
  }, [remoteClusterPrivilege, onChange]);
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    className: "remote-cluster-privilege-form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGrid, {
    css: (0, _react.css)`
                grid-template-columns: repeat(2, minmax(0, 1fr));
                @media (max-width: ${_uiTheme.euiThemeVars.euiBreakpoints.s}px) {
                  grid-template-columns: repeat(1, minmax(0, 1fr));
                }
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.remoteClusterPrivilegeForm.clustersFormRowLabel",
      defaultMessage: "Remote clusters",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 21
      }
    }),
    fullWidth: true
  }, validator.validateRemoteClusterPrivilegeClusterField(remoteClusterPrivilege), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_remote_clusters_combo_box.RemoteClusterComboBox, {
    "data-test-subj": `remoteClusterClustersInput${formIndex}`
    // @ts-expect-error upgrade typescript v5.9.3
    ,
    selectedOptions: ((_ref2 = [...remoteClusterPrivilege.clusters]) !== null && _ref2 !== void 0 ? _ref2 : []).map(toOption),
    onCreateOption: onCreateClusterOption,
    onChange: onClustersChange,
    isDisabled: isRoleReadOnly,
    placeholder: _i18n.i18n.translate('xpack.security.management.editRole.remoteClusterPrivilegeForm.clustersPlaceholder', {
      defaultMessage: 'Add a remote cluster…'
    }),
    remoteClusters: remoteClusters,
    type: "remote_cluster",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.remoteClusterPrivilegeForm.privilegesFormRowLabel",
      defaultMessage: "Privileges",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 21
      }
    }),
    fullWidth: true
  }, validator.validateRemoteClusterPrivilegePrivilegesField(remoteClusterPrivilege), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `remoteClusterPrivilegesInput${formIndex}`,
    options: availableRemoteClusterPrivileges.map(toOption),
    selectedOptions: remoteClusterPrivilege.privileges.map(toOption),
    onChange: onPrivilegeChange,
    isDisabled: isRoleReadOnly,
    placeholder: _i18n.i18n.translate('xpack.security.management.editRole.remoteClusterPrivilegeForm.privilegesPlaceholder', {
      defaultMessage: 'Add a privilege…'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 19
    }
  })))))), !isRoleReadOnly && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.security.management.editRole.remoteClusterPrivilegeForm.deleteRemoteClusterPrivilegeAriaLabel', {
      defaultMessage: 'Delete remote cluster privilege'
    }),
    color: "danger",
    onClick: onDelete,
    iconType: "trash",
    "data-test-subj": `deleteRemoteClusterPrivilegesButton${formIndex}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }))));
};
exports.RemoteClusterPrivilegesForm = RemoteClusterPrivilegesForm;