"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleDetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _query_rule_draggable_list = require("./query_rule_draggable_list/query_rule_draggable_list");
var _query_rule_flyout = require("./query_rule_flyout/query_rule_flyout");
var _use_generate_rule_id = require("../../hooks/use_generate_rule_id");
var _ruleset_detail_empty_prompt = require("../empty_prompt/ruleset_detail_empty_prompt");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _query_rule_search_results = require("./query_rule_draggable_list/query_rule_search_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_detail_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryRuleDetailPanel = ({
  rulesetId,
  tourInfo,
  rules,
  unfilteredRules,
  setIsFormDirty,
  setNewRules,
  updateRule,
  addNewRule,
  deleteRule,
  searchFilter = '',
  setSearchFilter = () => {},
  createMode = false
}) => {
  const [ruleIdToEdit, setRuleIdToEdit] = _react.default.useState(null);
  const [flyoutMode, setFlyoutMode] = _react.default.useState('edit');
  const hasSearchFilter = searchFilter.trim() !== '';
  const useTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    mutate: generateRuleId
  } = (0, _use_generate_rule_id.useGenerateRuleId)(rulesetId);
  (0, _react.useEffect)(() => {
    if (createMode && rules.length === 0) {
      generateRuleId(undefined, {
        onSuccess: newRuleId => {
          setFlyoutMode('create');
          setRuleIdToEdit(newRuleId);
        }
      });
    }
  }, [createMode, rules.length, addNewRule, generateRuleId, rulesetId]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, ruleIdToEdit !== null && /*#__PURE__*/_react.default.createElement(_query_rule_flyout.QueryRuleFlyout, {
    rules: rules,
    rulesetId: rulesetId,
    ruleId: ruleIdToEdit,
    onSave: rule => {
      if (flyoutMode === 'create') {
        addNewRule(rule);
      } else {
        updateRule(rule);
      }
      setRuleIdToEdit(null);
      setFlyoutMode('edit');
    },
    onClose: () => {
      setRuleIdToEdit(null);
      setFlyoutMode('edit');
    },
    setIsFormDirty: setIsFormDirty,
    createMode: flyoutMode === 'create',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    color: "primary",
    "data-test-subj": "queryRulesetDetailAddRuleButton",
    onClick: () => {
      useTracker === null || useTracker === void 0 ? void 0 : useTracker.click(_constants.AnalyticsEvents.addRuleClicked);
      generateRuleId(undefined, {
        onSuccess: newRuleId => {
          setFlyoutMode('create');
          setRuleIdToEdit(newRuleId);
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.queryRulesetDetail.addRuleButton",
    defaultMessage: "Add rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.queryRulesetDetail.ruleCount",
    defaultMessage: "{ruleCount, plural, one {# rule} other {# rules}}",
    values: {
      ruleCount: rules.length
    },
    "data-test-subj": "queryRulesetDetailRuleCount",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "queryRulesetDetailSearchFilter",
    placeholder: _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.searchFilterPlaceholder', {
      defaultMessage: 'Search rules...'
    }),
    value: searchFilter,
    onChange: e => {
      setSearchFilter(e.target.value);
      if (setIsFormDirty) {
        setIsFormDirty(true);
      }
    },
    fullWidth: true,
    incremental: true,
    "aria-label": _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.searchFilterAriaLabel', {
      defaultMessage: 'Search rules by ID, criteria, or actions'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, rules.length === 0 && /*#__PURE__*/_react.default.createElement(_ruleset_detail_empty_prompt.RulesetDetailEmptyPrompt, {
    isFilter: hasSearchFilter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 34
    }
  }), rules.length > 0 && !hasSearchFilter && /*#__PURE__*/_react.default.createElement(_query_rule_draggable_list.QueryRuleDraggableList, {
    rules: rules,
    rulesetId: rulesetId,
    onReorder: newRules => {
      setNewRules(newRules);
      if (setIsFormDirty) {
        setIsFormDirty(true);
      }
    },
    onEditRuleFlyoutOpen: ruleId => {
      setFlyoutMode('edit');
      setRuleIdToEdit(ruleId);
    },
    tourInfo: tourInfo,
    deleteRule: ruleId => {
      if (setIsFormDirty) {
        setIsFormDirty(true);
      }
      deleteRule === null || deleteRule === void 0 ? void 0 : deleteRule(ruleId);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }), rules.length > 0 && hasSearchFilter && /*#__PURE__*/_react.default.createElement(_query_rule_search_results.QueryRuleSearchResultsList, {
    rules: rules,
    unfilteredRules: unfilteredRules,
    rulesetId: rulesetId,
    onEditRuleFlyoutOpen: ruleId => {
      setFlyoutMode('edit');
      setRuleIdToEdit(ruleId);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }))));
};
exports.QueryRuleDetailPanel = QueryRuleDetailPanel;