"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecentDocsActionMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../hooks/use_kibana");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/index_documents/recent_docs_action_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RecentDocsActionMessage = ({
  indexName
}) => {
  const {
    services: {
      share
    }
  } = (0, _use_kibana.useKibana)();
  const discoverLocator = share.url.locators.get('DISCOVER_APP_LOCATOR');
  const onClick = async () => {
    await (discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.navigate({
      dataViewSpec: {
        title: indexName
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "subdued",
    borderRadius: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "calendar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchIndices.indexDocuments.recentDocsActionMessage', {
    defaultMessage: 'You are viewing the {pageSize} most recently ingested documents in this index. To see all documents, view in',
    values: {
      pageSize: _constants.DEFAULT_DOCUMENT_PAGE_SIZE
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.searchIndices.indexDocuments.recentDocsActionMessageLink', {
    defaultMessage: 'Discover.'
  }))))));
};
exports.RecentDocsActionMessage = RecentDocsActionMessage;