"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Result = exports.DEFAULT_VISIBLE_FIELDS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _results_fields = require("./results_fields");
var _rich_result_header = require("./rich_result_header");
var _result_header = require("./result_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/kbn-search-index-documents/components/result/result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_VISIBLE_FIELDS = exports.DEFAULT_VISIBLE_FIELDS = 3;
const Result = ({
  metaData,
  fields,
  defaultVisibleFields = DEFAULT_VISIBLE_FIELDS,
  compactCard = true,
  showScore = false,
  onDocumentClick,
  onDocumentDelete,
  hasDeleteDocumentsPrivilege
}) => {
  var _metaData$title, _metaData$title2;
  const [isExpanded, setIsExpanded] = (0, _react.useState)(false);
  const tooltipText = fields.length <= defaultVisibleFields ? _i18n.i18n.translate('xpack.searchIndexDocuments.result.expandTooltip.allVisible', {
    defaultMessage: 'All fields are visible'
  }) : isExpanded ? _i18n.i18n.translate('xpack.searchIndexDocuments.result.expandTooltip.showFewer', {
    defaultMessage: 'Show {amount} fewer fields',
    values: {
      amount: fields.length - defaultVisibleFields
    }
  }) : _i18n.i18n.translate('xpack.searchIndexDocuments.result.expandTooltip.showMore', {
    defaultMessage: 'Show {amount} more fields',
    values: {
      amount: fields.length - defaultVisibleFields
    }
  });
  const toolTipContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tooltipText);
  const showResultsFields = isExpanded ? fields.length > 0 : defaultVisibleFields > 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    "data-test-subj": "search-index-documents-result",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "m",
    color: "plain",
    className: "resultHeaderContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, compactCard && /*#__PURE__*/_react.default.createElement(_result_header.ResultHeader, {
    title: (_metaData$title = metaData.title) !== null && _metaData$title !== void 0 ? _metaData$title : _i18n.i18n.translate('searchIndexDocuments.result.title.id', {
      defaultMessage: 'Document id: {id}',
      values: {
        id: metaData.id
      }
    }),
    metaData: metaData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  }), !compactCard && /*#__PURE__*/_react.default.createElement(_rich_result_header.RichResultHeader, {
    showScore: showScore,
    title: (_metaData$title2 = metaData.title) !== null && _metaData$title2 !== void 0 ? _metaData$title2 : _i18n.i18n.translate('searchIndexDocuments.result.title.id', {
      defaultMessage: 'Document id: {id}',
      values: {
        id: metaData.id
      }
    }),
    onTitleClick: onDocumentClick,
    metaData: {
      ...metaData,
      onDocumentDelete,
      hasDeleteDocumentsPrivilege
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: toolTipContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    iconType: isExpanded ? 'fold' : 'unfold',
    color: isExpanded ? 'danger' : 'primary',
    "data-test-subj": isExpanded ? 'documentShowLessFields' : 'documentShowMoreFields',
    onClick: e => {
      e.stopPropagation();
      setIsExpanded(!isExpanded);
    },
    "aria-label": tooltipText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }))))), showResultsFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_results_fields.ResultFields, {
    documentId: metaData.id,
    isExpanded: isExpanded,
    fields: isExpanded ? fields : fields.slice(0, defaultVisibleFields),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  })))), showResultsFields && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 29
    }
  }));
};
exports.Result = Result;