"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _aiAssistant = require("@kbn/ai-assistant");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _lazy_nav_control = require("./components/nav_control/lazy_nav_control");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_assistant/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchAssistantPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.context = context;
    this.config = this.context.config.get();
  }
  setup(core) {
    return {};
  }
  start(coreStart, pluginsStart) {
    var _coreStart$applicatio;
    if (!this.config.ui.enabled) {
      return {};
    }
    const appService = (0, _aiAssistant.createAppService)({
      pluginsStart
    });
    const isEnabled = appService.isEnabled();
    const aiAssistantIsEnabled = (_coreStart$applicatio = coreStart.application.capabilities.observabilityAIAssistant) === null || _coreStart$applicatio === void 0 ? void 0 : _coreStart$applicatio.show;
    if (!isEnabled || !aiAssistantIsEnabled) {
      return {};
    }
    coreStart.chrome.navControls.registerRight({
      mount: element => {
        _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_lazy_nav_control.NavControlInitiator, {
          appService: appService,
          coreStart: coreStart,
          pluginsStart: pluginsStart,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 11
          }
        }), element, () => {});
        return () => {};
      },
      // right before the user profile
      order: 1001
    });
    return {};
  }
  stop() {}
}
exports.SearchAssistantPlugin = SearchAssistantPlugin;