"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUiApi = void 0;
var _common = require("../../common");
var _components = require("./components");
var _get_table_column_definition = require("./get_table_column_definition");
var _get_search_bar_filter = require("./get_search_bar_filter");
var _parse_search_query = require("./parse_search_query");
var _convert_name_to_reference = require("./convert_name_to_reference");
var _get_tag_list = require("./get_tag_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUiApi = ({
  cache,
  capabilities,
  client,
  ...startServices
}) => {
  const components = (0, _components.getComponents)({
    ...startServices,
    cache,
    capabilities,
    tagClient: client
  });
  const getTagList = (0, _get_tag_list.buildGetTagList)(cache);
  return {
    components,
    getTableColumnDefinition: (0, _get_table_column_definition.buildGetTableColumnDefinition)({
      components,
      cache
    }),
    getSearchBarFilter: (0, _get_search_bar_filter.buildGetSearchBarFilter)({
      getTagList
    }),
    parseSearchQuery: (0, _parse_search_query.buildParseSearchQuery)({
      cache
    }),
    convertNameToReference: (0, _convert_name_to_reference.buildConvertNameToReference)({
      cache
    }),
    getTagIdsFromReferences: _common.getTagIdsFromReferences,
    getTagIdFromName: tagName => (0, _common.convertTagNameToId)(tagName, cache.getState()),
    updateTagsReferences: _common.replaceTagReferences,
    getTag: tagId => (0, _common.getTag)(tagId, cache.getState()),
    getTagList
  };
};
exports.getUiApi = getUiApi;