"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateMetrics = validateMetrics;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps_config/validate_metrics.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function validateMetrics(metrics) {
  const missingTypes = metrics.reduce((accumMissingTypes, {
    name,
    types
  }) => {
    if (!types.length) {
      accumMissingTypes.push(name);
    }
    return accumMissingTypes;
  }, []);
  if (missingTypes.length) {
    const allMissingTypes = missingTypes.join(', ');
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.metricsTypesMissing",
      key: "xpack.rollupJobs.create.errors.metricsTypesMissing",
      defaultMessage: "Select metrics types for these fields or remove them: {allMissingTypes}.",
      values: {
        allMissingTypes
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 7
      }
    })];
  }
  return undefined;
}