"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _documentation_links = require("../../../services/documentation_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/components/deprecation_callout/deprecation_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
A component for displaying a deprecation warning.
 */
const DeprecationCallout = ({
  linksTestSubjPrefix
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Deprecated in 8.11.0",
    color: "warning",
    iconType: "warning",
    "data-test-subj": "rollupDeprecationCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.rollupJobs.deprecationCalloutMessage",
    defaultMessage: "Rollups are deprecated and will be removed in a future version. Check our {migrationGuideLink} and use {downsamplingLink} instead.",
    values: {
      migrationGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation_links.documentationLinks.elasticsearch.rollupMigratingToDownsampling,
        target: "_blank",
        "data-test-subj": `${linksTestSubjPrefix}-rollupDeprecationCalloutMigrationGuideLink`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.rollupJobs.deprecationCallout.migrationGuideLink', {
        defaultMessage: 'migration guide'
      })),
      downsamplingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation_links.documentationLinks.fleet.datastreamsDownsampling,
        target: "_blank",
        "data-test-subj": `${linksTestSubjPrefix}-rollupDeprecationCalloutDownsamplingDocLink`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.rollupJobs.deprecationCallout.downsamplingLink', {
        defaultMessage: 'downsampling'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
};
exports.DeprecationCallout = DeprecationCallout;