"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeCluster = removeCluster;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isRemoving: false
};
function removeCluster(state = initialState, action) {
  const {
    type
  } = action;
  switch (type) {
    case _action_types.REMOVE_CLUSTERS_START:
      return {
        isRemoving: true
      };
    case _action_types.REMOVE_CLUSTERS_FINISH:
      return {
        isRemoving: false
      };
    default:
      return state;
  }
}