"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveStateSwitch = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _kibana = require("../common/lib/kibana");
var _use_agent_policies = require("../agent_policies/use_agent_policies");
var _confirmation_modal = require("./form/confirmation_modal");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _use_update_pack = require("./use_update_pack");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/active_state_switch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const euiLoadingSpinnerCss = ({
  euiTheme
}) => ({
  marginRight: euiTheme.size.s
});
const ActiveStateSwitchComponent = ({
  item
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    application: {
      capabilities: {
        osquery: permissions
      }
    },
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  const [confirmationModal, setConfirmationModal] = (0, _react.useState)(false);
  const hideConfirmationModal = (0, _react.useCallback)(() => setConfirmationModal(false), []);
  const {
    data
  } = (0, _use_agent_policies.useAgentPolicies)();
  const agentCount = (0, _react.useMemo)(() => item.policy_ids.reduce((acc, policyId) => {
    var _data$agentPoliciesBy;
    return acc + ((data === null || data === void 0 ? void 0 : (_data$agentPoliciesBy = data.agentPoliciesById[policyId]) === null || _data$agentPoliciesBy === void 0 ? void 0 : _data$agentPoliciesBy.agents) || 0);
  }, 0), [data === null || data === void 0 ? void 0 : data.agentPoliciesById, item.policy_ids]);
  const {
    isLoading,
    mutateAsync
  } = (0, _use_update_pack.useUpdatePack)({
    options: {
      onSuccess: response => {
        var _response$data, _response$data2, _response$data3;
        queryClient.invalidateQueries([_constants.PACKS_ID]);
        setErrorToast();
        toasts.addSuccess(response !== null && response !== void 0 && (_response$data = response.data) !== null && _response$data !== void 0 && _response$data.enabled ? _i18n.i18n.translate('xpack.osquery.pack.table.activatedSuccessToastMessageText', {
          defaultMessage: 'Successfully activated "{packName}" pack',
          values: {
            packName: response === null || response === void 0 ? void 0 : (_response$data2 = response.data) === null || _response$data2 === void 0 ? void 0 : _response$data2.name
          }
        }) : _i18n.i18n.translate('xpack.osquery.pack.table.deactivatedSuccessToastMessageText', {
          defaultMessage: 'Successfully deactivated "{packName}" pack',
          values: {
            packName: response === null || response === void 0 ? void 0 : (_response$data3 = response.data) === null || _response$data3 === void 0 ? void 0 : _response$data3.name
          }
        }));
      }
    }
  });
  const handleToggleActive = (0, _react.useCallback)(() => {
    mutateAsync({
      id: item.saved_object_id,
      enabled: !item.enabled
    });
    hideConfirmationModal();
  }, [hideConfirmationModal, item, mutateAsync]);
  const handleToggleActiveClick = (0, _react.useCallback)(() => {
    if (agentCount) {
      return setConfirmationModal(true);
    }
    handleToggleActive();
  }, [agentCount, handleToggleActive]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    css: euiLoadingSpinnerCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: !!item.enabled,
    disabled: !permissions.writePacks || isLoading,
    showLabel: false,
    "aria-label": item.name,
    label: "",
    onChange: handleToggleActiveClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), confirmationModal && agentCount && /*#__PURE__*/_react.default.createElement(_confirmation_modal.ConfirmDeployAgentPolicyModal, {
    onConfirm: handleToggleActive,
    onCancel: hideConfirmationModal,
    agentCount: agentCount,
    agentPolicyCount: item.policy_ids.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }));
};
const ActiveStateSwitch = exports.ActiveStateSwitch = /*#__PURE__*/_react.default.memo(ActiveStateSwitchComponent);