"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnechatServices = void 0;
var _react = require("react");
var _onechat_services_context = require("../context/onechat_services_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnechatServices = () => {
  const services = (0, _react.useContext)(_onechat_services_context.OnechatServicesContext);
  if (services === undefined) {
    throw new Error(`OnechatServicesContext not set. Did you wrap your component in <OnechatServicesContext.Provider> ?`);
  }
  return services;
};
exports.useOnechatServices = useOnechatServices;