"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolsTags = void 0;
var _react = require("react");
var _use_tools = require("./use_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useToolsTags = () => {
  const {
    tools,
    isLoading,
    error
  } = (0, _use_tools.useToolsService)();
  const tags = (0, _react.useMemo)(() => {
    if (isLoading || error) return [];

    // Return unique tags across all tools
    return [...tools.reduce((tagsSet, tool) => {
      tool.tags.forEach(tag => tagsSet.add(tag));
      return tagsSet;
    }, new Set())];
  }, [tools, isLoading, error]);
  return {
    tags,
    isLoading
  };
};
exports.useToolsTags = useToolsTags;