"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundSteps = void 0;
var _conversation = require("@kbn/onechat-common/chat/conversation");
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _use_navigation = require("../../../../../hooks/use_navigation");
var _app_paths = require("../../../../../utils/app_paths");
var _tabular_data_result_step = require("./tabular_data_result_step");
var _other_result_step = require("./other_result_step");
var _query_result_step = require("./query_result_step");
var _tool_response_flyout = require("../../tool_response_flyout");
var _use_tool_results_flyout = require("../../../../../hooks/thinking/use_tool_results_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/steps/round_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Exposed in main thinking chain, for now query and tabular data
const mainThinkingResultTypes = [_tool_result.ToolResultType.query, _tool_result.ToolResultType.tabularData, _tool_result.ToolResultType.error];
// Populated in flyout
const flyoutResultTypes = [_tool_result.ToolResultType.other, _tool_result.ToolResultType.resource];
const ToolResultDisplay = ({
  toolResult
}) => {
  switch (toolResult.type) {
    // TODO: Add resource result step once we can reliably access the reference ID
    // case ToolResultType.resource:
    //   return <ResourceResultStep result={toolResult} />;
    case _tool_result.ToolResultType.query:
      return /*#__PURE__*/_react.default.createElement(_query_result_step.QueryResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 14
        }
      });
    case _tool_result.ToolResultType.tabularData:
      return /*#__PURE__*/_react.default.createElement(_tabular_data_result_step.TabularDataResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 14
        }
      });
    default:
      // Other results
      // Also showing Resource results as Other results for now as JSON blobs
      return /*#__PURE__*/_react.default.createElement(_other_result_step.OtherResultStep, {
        result: toolResult,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 14
        }
      });
  }
};
const ThinkingItemLayout = ({
  children
}) => {
  return (
    /*#__PURE__*/
    // No gap because we're using the margin on the horizontal divider
    _react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 7
      }
    }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    })))
  );
};
const ToolCallDisplay = ({
  step: {
    tool_id: toolId
  }
}) => {
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const toolHref = createOnechatUrl(_app_paths.appPaths.tools.details({
    toolId
  }));
  const toolLinkId = `tool-link-${toolId}`;
  return /*#__PURE__*/_react.default.createElement(ThinkingItemLayout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    role: "status",
    "aria-label": labels.toolCall,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.thinking.toolCallThinkingItem",
    defaultMessage: "Calling tool {tool}",
    values: {
      tool: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: toolHref,
        target: "_blank",
        id: toolLinkId,
        "aria-label": `${labels.toolLink} ${toolId}`,
        rel: "noopener noreferrer",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 19
        }
      }, toolId))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))));
};
const ToolProgressDisplay = ({
  progress
}) => {
  return /*#__PURE__*/_react.default.createElement(ThinkingItemLayout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "status",
    "aria-live": "polite",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, progress.message));
};
const labels = {
  roundThinkingSteps: _i18n.i18n.translate('xpack.onechat.conversation.thinking.stepsList', {
    defaultMessage: 'Round thinking steps'
  }),
  toolCall: _i18n.i18n.translate('xpack.onechat.thinking.toolCallLabel', {
    defaultMessage: 'Tool call'
  }),
  toolResponse: _i18n.i18n.translate('xpack.onechat.thinking.toolResponseLabel', {
    defaultMessage: 'Tool response'
  }),
  inspectResponse: _i18n.i18n.translate('xpack.onechat.thinking.inspectResponseLabel', {
    defaultMessage: 'Inspect tool response details'
  }),
  toolLink: _i18n.i18n.translate('xpack.onechat.thinking.toolLinkLabel', {
    defaultMessage: 'View tool details'
  }),
  agentReasoning: _i18n.i18n.translate('xpack.onechat.thinking.agentReasoningLabel', {
    defaultMessage: 'Agent reasoning'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.onechat.thinking.flyoutTitle', {
    defaultMessage: 'Tool response details'
  })
};
const getProgressionItems = ({
  step,
  stepIndex
}) => {
  var _step$progression$map, _step$progression;
  return (_step$progression$map = (_step$progression = step.progression) === null || _step$progression === void 0 ? void 0 : _step$progression.map((progress, index) => /*#__PURE__*/_react.default.createElement(ToolProgressDisplay, {
    key: `step-${stepIndex}-${step.tool_id}-progress-${index}`,
    progress: progress,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }))) !== null && _step$progression$map !== void 0 ? _step$progression$map : [];
};
const getMainThinkingResultItems = ({
  step,
  stepIndex
}) => {
  return step.results.filter(result => mainThinkingResultTypes.includes(result.type)).map((result, index) => /*#__PURE__*/_react.default.createElement(ThinkingItemLayout, {
    key: `step-${stepIndex}-${step.tool_id}-result-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ToolResultDisplay, {
    toolResult: result,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  })));
};
const getFlyoutResultItems = ({
  step,
  stepIndex,
  onOpenFlyout
}) => {
  const flyoutResultItems = step.results.filter(result => flyoutResultTypes.includes(result.type));
  if (flyoutResultItems.length > 0) {
    const responseId = `tool-response-${stepIndex}-${step.tool_id}`;
    const inspectButtonId = `inspect-response-${stepIndex}-${step.tool_id}`;
    return [/*#__PURE__*/_react.default.createElement(ThinkingItemLayout, {
      key: `step-${stepIndex}-${step.tool_id}-result-flyout`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      id: responseId,
      role: "status",
      "aria-label": labels.toolResponse,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.thinking.toolCallThinkingItem",
      defaultMessage: "Tool {tool} returned response. {inspectResponse}",
      values: {
        tool: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          "aria-label": _i18n.i18n.translate('xpack.onechat.thinking.toolName', {
            defaultMessage: 'Tool {toolId}',
            values: {
              toolId: step.tool_id
            }
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 211,
            columnNumber: 19
          }
        }, step.tool_id),
        inspectResponse: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => onOpenFlyout(flyoutResultItems),
          id: inspectButtonId,
          "aria-describedby": responseId,
          "aria-label": labels.inspectResponse,
          role: "button",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 221,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.onechat.conversation.roundResultsButton', {
          defaultMessage: 'Inspect response'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }))))];
  }
  return [];
};
const stepsListStyles = (0, _react2.css)`
  list-style: none;
  padding: 0;
`;
const RoundSteps = ({
  steps
}) => {
  // Each step will map to multiple thinking items
  // In the case of tool call steps we'll have
  // an item for the tool call, items for the progression, and items for the tool call results

  const {
    toolResults,
    isOpen: isToolResultsFlyoutOpen,
    openFlyout,
    closeFlyout
  } = (0, _use_tool_results_flyout.useToolResultsFlyout)();
  const renderedSteps = (0, _react.useMemo)(() => {
    return steps.flatMap((step, stepIndex) => {
      if ((0, _conversation.isToolCallStep)(step)) {
        return [/*#__PURE__*/_react.default.createElement(ToolCallDisplay, {
          key: `step-${stepIndex}-tool-call`,
          step: step,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 264,
            columnNumber: 11
          }
        }), ...getProgressionItems({
          step,
          stepIndex
        }), ...getMainThinkingResultItems({
          step,
          stepIndex
        }), ...getFlyoutResultItems({
          step,
          stepIndex,
          onOpenFlyout: openFlyout
        })];
      }

      // What is the difference between a reasoning step and a tool call progression message. When does the agent produce one over the other?
      // Is there any difference for how we should display reasoning and progression?
      if ((0, _conversation.isReasoningStep)(step)) {
        return [/*#__PURE__*/_react.default.createElement(ThinkingItemLayout, {
          key: `step-reasoning-${stepIndex}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 279,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          role: "status",
          "aria-live": "polite",
          "aria-label": labels.agentReasoning,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 280,
            columnNumber: 13
          }
        }, step.reasoning))];
      }
      return [];
    });
  }, [steps, openFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("ol", {
    css: stepsListStyles,
    "aria-label": labels.roundThinkingSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }, renderedSteps), /*#__PURE__*/_react.default.createElement(_tool_response_flyout.ToolResponseFlyout, {
    isOpen: isToolResultsFlyoutOpen,
    onClose: closeFlyout,
    "aria-label": labels.flyoutTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }, (toolResults !== null && toolResults !== void 0 ? toolResults : []).map((result, index) => /*#__PURE__*/_react.default.createElement(ThinkingItemLayout, {
    key: `flyout-result-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(ToolResultDisplay, {
    toolResult: result,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 13
    }
  })))));
};
exports.RoundSteps = RoundSteps;