"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Conversation = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_conversation = require("../../hooks/use_conversation");
var _conversation_input_form = require("./conversation_input/conversation_input_form");
var _conversation_rounds = require("./conversation_rounds/conversation_rounds");
var _new_conversation_prompt = require("./new_conversation_prompt");
var _use_sync_agent_id = require("../../hooks/use_sync_agent_id");
var _use_conversation_id = require("../../hooks/use_conversation_id");
var _send_message_context = require("../../context/send_message/send_message_context");
var _use_conversation_scroll_actions = require("../../hooks/use_conversation_scroll_actions");
var _conversation_grid = require("./conversation_grid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fullHeightStyles = (0, _react.css)`
  height: 100%;
`;
const conversationContainerStyles = (0, _react.css)`
  ${fullHeightStyles}
  width: 100%;
`;
const Conversation = () => {
  var _location$state$shoul, _location$state, _scrollContainerRef$c, _scrollContainerRef$c2;
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const hasActiveConversation = (0, _use_conversation.useHasActiveConversation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isResponseLoading
  } = (0, _send_message_context.useSendMessage)();
  const {
    isFetched
  } = (0, _use_conversation.useConversationStatus)();
  const location = (0, _reactRouterDom.useLocation)();
  const shouldStickToBottom = (_location$state$shoul = (_location$state = location.state) === null || _location$state === void 0 ? void 0 : _location$state.shouldStickToBottom) !== null && _location$state$shoul !== void 0 ? _location$state$shoul : true;
  const scrollContainerRef = (0, _react2.useRef)(null);
  const {
    showScrollButton,
    scrollToMostRecentRoundBottom,
    scrollToMostRecentRoundTop,
    stickToBottom
  } = (0, _use_conversation_scroll_actions.useConversationScrollActions)({
    isResponseLoading,
    conversationId: conversationId || '',
    scrollContainer: scrollContainerRef.current
  });
  const scrollContainerHeight = (_scrollContainerRef$c = (_scrollContainerRef$c2 = scrollContainerRef.current) === null || _scrollContainerRef$c2 === void 0 ? void 0 : _scrollContainerRef$c2.clientHeight) !== null && _scrollContainerRef$c !== void 0 ? _scrollContainerRef$c : 0;

  // Stick to bottom only when user returns to an existing conversation (conversationId is defined and changes)
  (0, _react2.useEffect)(() => {
    if (isFetched && conversationId && shouldStickToBottom) {
      requestAnimationFrame(() => {
        stickToBottom();
      });
    }
  }, [stickToBottom, isFetched, conversationId, shouldStickToBottom]);
  const scrollContainerStyles = (0, _react.css)`
    overflow-y: auto;
    ${fullHeightStyles}
    ${(0, _eui.useEuiScrollBar)()}
  `;
  (0, _use_sync_agent_id.useSyncAgentId)();
  const scrollDownButtonStyles = (0, _react.css)`
    position: absolute;
    bottom: ${euiTheme.size.xl};
    left: 50%;
    transform: translateX(-50%);
  `;
  const contentStyles = (0, _react.css)`
    ${fullHeightStyles}
    align-items: stretch;
  `;
  if (!hasActiveConversation) {
    return /*#__PURE__*/_react2.default.createElement(_new_conversation_prompt.NewConversationPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiResizableContainer, {
    direction: "vertical",
    css: conversationContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, (EuiResizablePanel, EuiResizableButton) => {
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(EuiResizablePanel, {
      initialSize: 80,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement("div", {
      ref: scrollContainerRef,
      css: scrollContainerStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_conversation_rounds.ConversationRounds, {
      scrollContainerHeight: scrollContainerHeight,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 17
      }
    })), showScrollButton && /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      color: "text",
      css: scrollDownButtonStyles,
      iconType: "sortDown",
      "aria-label": "Scroll down",
      onClick: scrollToMostRecentRoundBottom,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react2.default.createElement(EuiResizableButton, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react2.default.createElement(EuiResizablePanel, {
      initialSize: 20,
      minSize: "20%",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_conversation_grid.ConversationContent, {
      css: contentStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_conversation_input_form.ConversationInputForm, {
      onSubmit: scrollToMostRecentRoundTop,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 17
      }
    }))));
  });
};
exports.Conversation = Conversation;