"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _onechatBrowser = require("@kbn/onechat-browser");
var _onechatCommon = require("@kbn/onechat-common");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _lodash = require("lodash");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../common/doc_links");
var _use_agent_edit = require("../../../hooks/agents/use_agent_edit");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_navigation = require("../../../hooks/use_navigation");
var _search_param_names = require("../../../search_param_names");
var _app_paths = require("../../../utils/app_paths");
var _color = require("../../../utils/color");
var _i18n2 = require("../../../utils/i18n");
var _zod_resolver = require("../../../utils/zod_resolver");
var _agent_avatar = require("../agent_avatar");
var _agent_form_validation = require("./agent_form_validation");
var _settings_tab = require("./tabs/settings_tab");
var _tools_tab = require("./tabs/tools_tab");
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/agent_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUTTON_IDS = {
  SAVE: 'save',
  SAVE_AND_CHAT: 'saveAndChat'
};

// We can't use useDeleteAgent here because DeleteAgentContext is not available for create mode
// so pass onDelete as prop for edit mode.

const AgentForm = ({
  editingAgentId,
  onDelete
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const {
    manageAgents
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  // Resolve state updates before navigation to avoid triggering unsaved changes prompt
  const deferNavigateToOnechatUrl = (0, _react.useCallback)((...args) => {
    (0, _lodash.defer)(() => navigateToOnechatUrl(...args));
  }, [navigateToOnechatUrl]);
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    notifications,
    http,
    overlays: {
      openConfirm
    },
    application: {
      navigateToUrl
    },
    appParams: {
      history
    }
  } = services;
  const agentFormId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'agentForm'
  });
  const isCreateMode = !editingAgentId;
  const onSaveSuccess = () => {
    notifications.toasts.addSuccess(isCreateMode ? _i18n.i18n.translate('xpack.onechat.agents.createSuccessMessage', {
      defaultMessage: 'Agent created successfully'
    }) : _i18n.i18n.translate('xpack.onechat.agents.updateSuccessMessage', {
      defaultMessage: 'Agent updated successfully'
    }));
  };
  const onSaveError = err => {
    const errorMessageTitle = isCreateMode ? _i18n.i18n.translate('xpack.onechat.agents.createErrorMessage', {
      defaultMessage: 'Failed to create agent'
    }) : _i18n.i18n.translate('xpack.onechat.agents.updateErrorMessage', {
      defaultMessage: 'Failed to update agent'
    });
    notifications.toasts.addDanger({
      title: errorMessageTitle,
      text: (0, _onechatBrowser.formatOnechatErrorMessage)(err)
    });
  };
  const {
    state: agentState,
    isLoading,
    isSubmitting,
    submit,
    tools,
    error
  } = (0, _use_agent_edit.useAgentEdit)({
    editingAgentId,
    onSaveSuccess,
    onSaveError
  });
  const formMethods = (0, _reactHookForm.useForm)({
    defaultValues: {
      ...agentState
    },
    mode: 'onBlur',
    resolver: (0, _zod_resolver.zodResolver)(_agent_form_validation.agentFormSchema)
  });
  const {
    control,
    handleSubmit,
    reset,
    formState,
    watch
  } = formMethods;
  const {
    errors,
    isDirty,
    isSubmitSuccessful
  } = formState;
  const hasErrors = Object.keys(errors).length > 0;
  const [isCancelling, setIsCancelling] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (agentState && !isLoading) {
      reset(agentState);
    }
  }, [agentState, isLoading, reset]);
  const handleCancel = (0, _react.useCallback)(() => {
    setIsCancelling(true);
    (0, _lodash.defer)(() => navigateToOnechatUrl(_app_paths.appPaths.agents.list));
  }, [navigateToOnechatUrl]);
  const handleSave = (0, _react.useCallback)(async (data, {
    navigateToListView = true,
    buttonId = BUTTON_IDS.SAVE
  } = {}) => {
    setSubmittingButtonId(buttonId);
    try {
      await submit(data);
    } finally {
      setSubmittingButtonId(undefined);
    }
    if (navigateToListView) {
      deferNavigateToOnechatUrl(_app_paths.appPaths.agents.list);
    }
  }, [submit, deferNavigateToOnechatUrl]);
  const handleSaveAndChat = (0, _react.useCallback)(async data => {
    await handleSave(data, {
      buttonId: BUTTON_IDS.SAVE_AND_CHAT,
      navigateToListView: false
    });
    deferNavigateToOnechatUrl(_app_paths.appPaths.chat.newWithAgent({
      agentId: data.id
    }));
  }, [deferNavigateToOnechatUrl, handleSave]);
  const isFormDisabled = isLoading || isSubmitting;
  const isSaveDisabled = isFormDisabled || hasErrors || !isCreateMode && !isDirty;
  const [isContextMenuOpen, setContextMenuOpen] = (0, _react.useState)(false);
  const [isAdditionalActionsMenuOpen, setAdditionalActionsMenuOpen] = (0, _react.useState)(false);
  const [submittingButtonId, setSubmittingButtonId] = (0, _react.useState)();
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    hasUnsavedChanges: isDirty && !isSubmitSuccessful && !isCancelling,
    history,
    http,
    navigateToUrl,
    openConfirm,
    shouldPromptOnReplace: false
  });
  const agentTools = watch('configuration.tools');
  const activeToolsCount = (0, _react.useMemo)(() => {
    return (0, _onechatCommon.filterToolsBySelection)(tools, agentTools).length;
  }, [tools, agentTools]);
  const tabs = (0, _react.useMemo)(() => [{
    id: 'settings',
    name: _i18n.i18n.translate('xpack.onechat.agents.form.settingsTab', {
      defaultMessage: 'Settings'
    }),
    content: /*#__PURE__*/_react.default.createElement(_settings_tab.AgentSettingsTab, {
      control: control,
      formState: formState,
      isCreateMode: isCreateMode,
      isFormDisabled: isFormDisabled || !manageAgents,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 11
      }
    })
  }, {
    id: 'tools',
    name: _i18n.i18n.translate('xpack.onechat.agents.form.toolsTab', {
      defaultMessage: 'Tools'
    }),
    content: /*#__PURE__*/_react.default.createElement(_tools_tab.ToolsTab, {
      control: control,
      tools: tools,
      isLoading: isLoading,
      isFormDisabled: isFormDisabled || !manageAgents,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 11
      }
    }),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued",
      css: (0, _react2.css)`
              block-size: 20px;
              min-inline-size: ${euiTheme.size.l};
              padding: 0 ${euiTheme.size.xs};
            `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 11
      }
    }, activeToolsCount)
  }], [control, formState, isCreateMode, isFormDisabled, tools, isLoading, euiTheme, activeToolsCount, manageAgents]);
  const renderSaveButton = (0, _react.useCallback)(({
    size = 's'
  } = {}) => {
    const saveButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      form: agentFormId,
      size: size,
      type: "submit",
      minWidth: "112px",
      fill: true,
      iconType: "save",
      isLoading: submittingButtonId === BUTTON_IDS.SAVE,
      isDisabled: isSaveDisabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.onechat.agents.form.saveButton', {
      defaultMessage: 'Save'
    }));
    return hasErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      content: _i18n.i18n.translate('xpack.onechat.agents.form.saveButtonTooltip', {
        defaultMessage: 'Resolve all form errors to save.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 9
      }
    }, saveButton) : saveButton;
  }, [agentFormId, submittingButtonId, isSaveDisabled, hasErrors]);
  const renderChatButton = (0, _react.useCallback)(({
    size = 's'
  } = {}) => {
    const commonProps = {
      size,
      iconType: 'comment',
      isDisabled: isFormDisabled || hasErrors,
      minWidth: '112px'
    };
    return !isCreateMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, commonProps, {
      onClick: () => navigateToOnechatUrl(_app_paths.appPaths.chat.newWithAgent({
        agentId: editingAgentId
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 9
      }
    }), _i18n.i18n.translate('xpack.onechat.agents.form.chatButton', {
      defaultMessage: 'Chat'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, commonProps, {
      isLoading: submittingButtonId === BUTTON_IDS.SAVE_AND_CHAT,
      onClick: handleSubmit(handleSaveAndChat),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 328,
        columnNumber: 9
      }
    }), _i18n.i18n.translate('xpack.onechat.agents.form.saveAndChatButton', {
      defaultMessage: 'Save and chat'
    }));
  }, [navigateToOnechatUrl, isFormDisabled, hasErrors, editingAgentId, isCreateMode, handleSubmit, handleSaveAndChat, submittingButtonId]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      style: {
        minHeight: '200px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 11
      }
    })));
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.onechat.agents.errorTitle', {
        defaultMessage: 'Error loading agent'
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.onechat.agents.errorMessage', {
      defaultMessage: 'Unable to load the agent. {errorMessage}',
      values: {
        errorMessage: (error === null || error === void 0 ? void 0 : error.message) || String(error)
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => navigateToOnechatUrl(_app_paths.appPaths.agents.list),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 380,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.onechat.agents.backToListButton', {
      defaultMessage: 'Back to agents list'
    })));
  }
  const agentName = watch('name');
  const agentDescription = watch('description');
  const agentAvatarSymbol = watch('avatar_symbol');
  const watchedAvatarColor = watch('avatar_color');
  const agentAvatarColor = watchedAvatarColor && (0, _color.isValidAgentAvatarColor)(watchedAvatarColor) ? watchedAvatarColor : undefined;
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    panelled: true,
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 402,
        columnNumber: 11
      }
    }, !isCreateMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_agent_avatar.AgentAvatar, {
      size: "l",
      agent: {
        name: agentName,
        avatar_symbol: agentAvatarSymbol,
        avatar_color: agentAvatarColor
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 405,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 415,
        columnNumber: 13
      }
    }, isCreateMode ? _i18n2.labels.agents.newAgent : agentName)),
    description: isCreateMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.createAgent.description",
      defaultMessage: "Create an AI agent with custom instructions, assign it tools to work with your data, and make it easily findable for your team. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.agentBuilderAgents,
          target: "_blank",
          "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.settings.systemReferencesLearnMoreAriaLabel', {
            defaultMessage: 'Learn more about agents in the documentation'
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 425,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.systemReferencesLearnMore', {
          defaultMessage: 'Learn more'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 420,
        columnNumber: 13
      }
    }) : agentDescription,
    rightSideItems: [...(!manageAgents ? [] : !isCreateMode ? [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 454,
        columnNumber: 17
      }
    }, renderSaveButton({
      size: 'm'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelPaddingSize: "xs",
      isOpen: isAdditionalActionsMenuOpen,
      closePopover: () => setAdditionalActionsMenuOpen(false),
      zIndex: Number(euiTheme.levels.header) - 1,
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.openMenuLabel', {
          defaultMessage: 'Open menu'
        }),
        size: "m",
        isDisabled: isSaveDisabled,
        display: "fill",
        iconType: "arrowDown",
        onClick: () => setAdditionalActionsMenuOpen(openState => !openState),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 462,
          columnNumber: 23
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 456,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "comment",
        size: "s",
        disabled: isSaveDisabled,
        onClick: handleSubmit(handleSaveAndChat),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 477,
          columnNumber: 25
        }
      }, _i18n.i18n.translate('xpack.onechat.agents.form.saveAndChatButton', {
        defaultMessage: 'Save and chat'
      }))],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 474,
        columnNumber: 21
      }
    })))] : [renderSaveButton({
      size: 'm'
    })]), renderChatButton({
      size: 'm'
    }), ...(!manageAgents ? [] : !isCreateMode ? [/*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        size: "m",
        "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.openMenuLabel', {
          defaultMessage: 'Open menu'
        }),
        iconType: "boxesVertical",
        onClick: () => setContextMenuOpen(!isContextMenuOpen),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 500,
          columnNumber: 21
        }
      }),
      isOpen: isContextMenuOpen,
      closePopover: () => setContextMenuOpen(false),
      anchorPosition: "downLeft",
      panelPaddingSize: "xs",
      zIndex: Number(euiTheme.levels.header) - 1,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 498,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "copy",
        size: "s",
        onClick: () => {
          setContextMenuOpen(false);
          navigateToOnechatUrl(_app_paths.appPaths.agents.new, {
            [_search_param_names.searchParamNames.sourceId]: editingAgentId
          });
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 518,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.onechat.agents.form.cloneButton', {
        defaultMessage: 'Clone'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "trash",
        size: "s",
        css: (0, _react2.css)`
                          color: ${euiTheme.colors.textDanger};
                        `,
        onClick: () => {
          setContextMenuOpen(false);
          onDelete === null || onDelete === void 0 ? void 0 : onDelete();
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 532,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.onechat.agents.form.deleteButton', {
        defaultMessage: 'Delete'
      }))],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 515,
        columnNumber: 19
      }
    }))] : [])],
    rightSideGroupProps: {
      gutterSize: 's'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 555,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, formMethods, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    id: agentFormId,
    component: "form",
    onSubmit: handleSubmit(data => handleSave(data)),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 557,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 563,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    css: (0, _react2.css)`
            height: ${!isMobile ? euiTheme.size.xxxxl : '144px'};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 566,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    paddingSize: "m",
    restrictWidth: false,
    position: "fixed",
    usePortal: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 572,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 579,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n2.labels.agents.settings.cancelButtonLabel,
    size: "s",
    iconType: "cross",
    color: "text",
    onClick: handleCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 580,
      columnNumber: 13
    }
  }, _i18n2.labels.agents.settings.cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 590,
      columnNumber: 11
    }
  }, renderChatButton()), manageAgents && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 591,
      columnNumber: 28
    }
  }, renderSaveButton()))));
};
exports.AgentForm = AgentForm;