"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPage = OverviewPage;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _loading_observability = require("../../components/loading_observability");
var _use_date_picker_context = require("../../hooks/use_date_picker_context");
var _use_has_data = require("../../hooks/use_has_data");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_time_buckets = require("../../hooks/use_time_buckets");
var _data_sections = require("./components/data_sections");
var _header_actions = require("./components/header_actions/header_actions");
var _header_menu = require("./components/header_menu/header_menu");
var _get_news_feed = require("./components/news_feed/helpers/get_news_feed");
var _news_feed = require("./components/news_feed/news_feed");
var _observability_onboarding_callout = require("./components/observability_onboarding_callout");
var _calculate_bucket_size = require("./helpers/calculate_bucket_size");
var _kibana_react = require("../../utils/kibana_react");
var _has_data_context = require("../../context/has_data_context/has_data_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function OverviewPage() {
  var _newsFeed$items;
  const {
    http,
    observabilityAIAssistant,
    kibanaVersion,
    serverless: isServerless,
    share
  } = (0, _kibana_react.useKibana)().services;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const onboardingHref = onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.useUrl({});
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.overviewLinkText', {
      defaultMessage: 'Overview'
    })
  }], {
    classicOnly: true
  });
  const {
    data: newsFeed
  } = (0, _public.useFetcher)(() => {
    if (!Boolean(isServerless)) {
      return (0, _get_news_feed.getNewsFeed)({
        http,
        kibanaVersion
      });
    }
  }, [http, kibanaVersion, isServerless]);
  const {
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  // we need to filter out unwanted apps
  const hasData = (0, _react.useMemo)(() => Object.entries(hasDataMap).reduce((acc, [app, value]) => {
    if (_data_sections.DATA_SECTIONS.includes(app)) {
      acc[app] = value;
    }
    return acc;
  }, {}), [hasDataMap]);
  const hasAnyData = (0, _react.useMemo)(() => Object.values(hasData).some(d => d === null || d === void 0 ? void 0 : d.hasData), [hasData]);
  const isAllRequestsComplete = (0, _react.useMemo)(() => {
    return _data_sections.DATA_SECTIONS.every(app => {
      const section = hasData[app];
      return (section === null || section === void 0 ? void 0 : section.status) === _public.FETCH_STATUS.SUCCESS;
    });
  }, [hasData]);
  const {
    setScreenContext
  } = (observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service) || {};
  const appsWithoutData = Object.keys(hasData).sort().reduce((acc, app) => {
    const section = hasData[app];
    if ((section === null || section === void 0 ? void 0 : section.status) === 'success' && !(section !== null && section !== void 0 && section.hasData)) {
      const appName = _has_data_context.appLabels[app];
      return `${acc}${appName}, `;
    }
    return acc;
  }, '').slice(0, -2);
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      screenDescription: `The user is viewing the Overview page which shows a summary of the following apps: ${JSON.stringify(hasData)}`,
      starterPrompts: [...(appsWithoutData.length > 0 ? [{
        title: _i18n.i18n.translate('xpack.observability.aiAssistant.starterPrompts.explainNoData.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.observability.aiAssistant.starterPrompts.explainNoData.prompt', {
          defaultMessage: `Why don't I see any data for the {appsWithoutData} sections?`,
          values: {
            appsWithoutData
          }
        }),
        icon: 'sparkles'
      }] : [])]
    });
  }, [appsWithoutData, hasData, setScreenContext]);
  const {
    absoluteStart,
    absoluteEnd
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const timeBuckets = (0, _use_time_buckets.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _calculate_bucket_size.calculateBucketSize)({
    start: absoluteStart,
    end: absoluteEnd,
    timeBuckets
  }), [absoluteStart, absoluteEnd, timeBuckets]);
  if (!hasAnyData && !isAllRequestsComplete) {
    return /*#__PURE__*/_react.default.createElement(_loading_observability.LoadingObservability, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    isPageDataLoaded: isAllRequestsComplete,
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.overview.pageTitle', {
        defaultMessage: 'Overview'
      }),
      rightSideItems: hasAnyData ? [/*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 39
        }
      })] : [],
      rightSideGroupProps: {
        responsive: true
      },
      'data-test-subj': 'obltOverviewPageHeader'
    },
    pageSectionProps: {
      contentProps: {
        style: {
          display: 'flex',
          flexDirection: 'column',
          flexGrow: 1
        }
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }), hasAnyData ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_observability_onboarding_callout.ObservabilityOnboardingCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_data_sections.DataSections, {
    bucketSize: bucketSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoObservability",
    "data-test-subj": "obltOverviewNoDataPrompt",
    css: {
      flexGrow: 1,
      display: 'flex',
      alignItems: 'center'
    },
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability.overview.emptyState.title', {
      defaultMessage: 'Welcome to Observability'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability.overview.emptyState.body', {
      defaultMessage: 'Start collecting data to start detecting and resolving problems with your systems.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yOverviewPageAddDataButton",
      color: "primary",
      fill: true,
      href: onboardingHref,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability.overview.emptyState.action', {
      defaultMessage: 'Add data'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    css: {
      width: 'auto',
      marginLeft: `-${euiTheme.size.l}`,
      marginRight: `-${euiTheme.size.l}`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    css: {
      flexGrow: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 7
    }
  }, !!(newsFeed !== null && newsFeed !== void 0 && (_newsFeed$items = newsFeed.items) !== null && _newsFeed$items !== void 0 && _newsFeed$items.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_news_feed.NewsFeed, {
    items: newsFeed.items.slice(0, 3),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.ExternalResourceLinks, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }))));
}