"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizeData = VisualizeData;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _accordion_with_icon = require("../shared/accordion_with_icon");
var _get_started_panel = require("../shared/get_started_panel");
var _use_aws_service_get_started_list = require("./use_aws_service_get_started_list");
var _auto_refresh_callout = require("./auto_refresh_callout");
var _progress_callout = require("./progress_callout");
var _utils = require("./utils");
var _use_populated_aws_index_list = require("./use_populated_aws_index_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/firehose/visualize_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const REQUEST_PENDING_STATUS_LIST = [_use_fetcher.FETCH_STATUS.LOADING, _use_fetcher.FETCH_STATUS.NOT_INITIATED];
function VisualizeData({
  onboardingId,
  selectedCreateStackOption,
  hasExistingData
}) {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  const [orderedVisibleAWSServiceList, setOrderedVisibleAWSServiceList] = (0, _react.useState)([]);
  const [shouldShowDataReceivedToast, setShouldShowDataReceivedToast] = (0, _react.useState)(!hasExistingData);
  const {
    data: populatedAWSIndexList,
    status,
    refetch
  } = (0, _use_populated_aws_index_list.usePopulatedAWSIndexList)();
  const {
    services: {
      notifications,
      context: {
        cloudServiceProvider
      }
    }
  } = (0, _public.useKibana)();
  const awsServiceGetStartedConfigList = (0, _use_aws_service_get_started_list.useAWSServiceGetStartedList)();
  (0, _react.useEffect)(() => {
    if (shouldShowDataReceivedToast && Array.isArray(populatedAWSIndexList) && populatedAWSIndexList.length > 0) {
      notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.dataReceivedToastTitle', {
          defaultMessage: 'Your data is on its way'
        }),
        text: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.dataReceivedToastText', {
          defaultMessage: 'We’ve begun processing your data. In the background, we automatically refresh every few seconds to capture more incoming data.'
        })
      }, {
        toastLifeTimeMs: 10000
      });
      setShouldShowDataReceivedToast(false);
    }
    setOrderedVisibleAWSServiceList(currentList =>
    /**
     * unionBy() ensures uniqueness of the resulting list
     * and preserves the order of the first list passed to it,
     * which in turn keeps already visible services in the UI
     * in place and new services are only appended to the end.
     */
    (0, _lodash.unionBy)(currentList, awsServiceGetStartedConfigList.filter(({
      indexNameList
    }) => indexNameList.some(indexName => populatedAWSIndexList === null || populatedAWSIndexList === void 0 ? void 0 : populatedAWSIndexList.includes(indexName))), 'id'));
  }, [awsServiceGetStartedConfigList, notifications === null || notifications === void 0 ? void 0 : notifications.toasts, populatedAWSIndexList, shouldShowDataReceivedToast]);
  (0, _useInterval.default)(() => {
    if (REQUEST_PENDING_STATUS_LIST.includes(status)) {
      return;
    }
    refetch();
  }, _utils.HAS_DATA_FETCH_INTERVAL);
  if (populatedAWSIndexList === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.firehosePanel.visualizeDataDescription",
    defaultMessage: "Once the Firehose stream is created, data capture will begin automatically, and the incoming data will be displayed below.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), orderedVisibleAWSServiceList.length === 0 && /*#__PURE__*/_react.default.createElement(_progress_callout.ProgressCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 53
    }
  }), orderedVisibleAWSServiceList.length > 0 && /*#__PURE__*/_react.default.createElement(_auto_refresh_callout.AutoRefreshCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 51
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "observabilityOnboardingAWSServiceList",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, orderedVisibleAWSServiceList.map(({
    id,
    actionLinks,
    title,
    logoURL,
    previewImage
  }, index) => {
    return /*#__PURE__*/_react.default.createElement(_accordion_with_icon.AccordionWithIcon, {
      "data-test-subj": `observabilityOnboardingAWSService-${id}`,
      key: id,
      id: `${accordionId}_${id}`,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: logoURL,
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 23
        }
      }),
      title: title,
      initialIsOpen: true,
      borders: index === 0 || index === orderedVisibleAWSServiceList.length - 1 ? 'none' : 'horizontal',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_get_started_panel.GetStartedPanel, {
      onboardingFlowType: "firehose",
      dataset: id,
      telemetryEventContext: {
        firehose: {
          selectedCreateStackOption,
          cloudServiceProvider
        }
      },
      integration: "aws",
      newTab: true,
      isLoading: false,
      actionLinks: actionLinks,
      previewImage: previewImage,
      onboardingId: onboardingId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 17
      }
    }));
  })));
}