"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTemplate = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _autoopsPromotionCallout = require("@kbn/autoops-promotion-callout");
var _use_title = require("../hooks/use_title");
var _toolbar = require("../../components/shared/toolbar");
var _use_monitoring_time = require("../hooks/use_monitoring_time");
var _components = require("../../components");
var _setup_mode = require("../../lib/setup_mode");
var _enums = require("../../../common/enums");
var _alerts_dropdown = require("../../alerts/alerts_dropdown");
var _use_request_error_handler = require("../hooks/use_request_error_handler");
var _toggle_button = require("../../components/setup_mode/toggle_button");
var _header_action_menu_context = require("../contexts/header_action_menu_context");
var _header_menu = require("../../components/header_menu");
var _legacy_shims = require("../../legacy_shims");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/page_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PageTemplate = ({
  title,
  pageTitle,
  tabs,
  getPageData,
  product,
  showAutoOpsPromotion,
  children
}) => {
  (0, _use_title.useTitle)('', title);
  const {
    currentTimerange
  } = (0, _use_monitoring_time.useMonitoringTimeContainerContext)();
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const [isRequestPending, setIsRequestPending] = (0, _react.useState)(false);
  const history = (0, _reactRouterDom.useHistory)();
  const [hasError, setHasError] = (0, _react.useState)(false);
  const handleRequestError = (0, _use_request_error_handler.useRequestErrorHandler)();
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_context.HeaderActionMenuContext);
  const getPageDataResponseHandler = (0, _react.useCallback)(result => {
    setHasError(false);
    return result;
  }, [setHasError]);
  (0, _react.useEffect)(() => {
    setIsRequestPending(true);
    getPageData === null || getPageData === void 0 ? void 0 : getPageData().then(getPageDataResponseHandler).catch(err => {
      handleRequestError(err);
      setHasError(true);
    }).finally(() => {
      setLoaded(true);
      setIsRequestPending(false);
    });
  }, [getPageData, currentTimerange, getPageDataResponseHandler, handleRequestError]);
  const onRefresh = () => {
    // don't refresh when a request is pending
    if (isRequestPending) return;
    setIsRequestPending(true);
    getPageData === null || getPageData === void 0 ? void 0 : getPageData().then(getPageDataResponseHandler).catch(handleRequestError).finally(() => {
      setIsRequestPending(false);
    });
    if ((0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
      (0, _setup_mode.updateSetupModeData)();
    }
  };
  const createHref = route => history.createHref({
    pathname: route
  });
  const isTabSelected = route => history.location.pathname === route;
  const renderContent = () => {
    if (hasError) return null;
    if (getPageData && !loaded) return /*#__PURE__*/_react.default.createElement(_components.PageLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 40
      }
    });
    return children;
  };
  const {
    supported,
    enabled
  } = (0, _setup_mode.getSetupModeState)();
  const shouldShowAutoOpsPromotion = showAutoOpsPromotion && !_legacy_shims.Legacy.shims.isCloud && _legacy_shims.Legacy.shims.hasEnterpriseLicense;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    grow: false,
    "data-test-subj": "monitoringAppContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 11
    }
  }, supported && /*#__PURE__*/_react.default.createElement(_toggle_button.SetupModeToggleButton, {
    enabled: enabled,
    toggleSetupMode: _setup_mode.toggleSetupMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_alerts_dropdown.AlertsDropdown, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_toolbar.MonitoringToolbar, {
    pageTitle: pageTitle,
    onRefresh: onRefresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }), shouldShowAutoOpsPromotion && /*#__PURE__*/_react.default.createElement(_autoopsPromotionCallout.AutoOpsPromotionCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 40
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), tabs && /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, tabs.map((item, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: idx,
      disabled: isDisabledTab(product),
      title: item.label,
      "data-test-subj": item.testSubj,
      href: item.route ? createHref(item.route) : undefined,
      isSelected: item.route ? isTabSelected(item.route) : undefined,
      onClick: item.onClick,
      prepend: item.prepend,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }, item.label);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    paddingSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, renderContent()))));
};
exports.PageTemplate = PageTemplate;
function isDisabledTab(product) {
  const setupMode = (0, _setup_mode.getSetupModeState)();
  if (!(0, _setup_mode.isSetupModeFeatureEnabled)(_enums.SetupModeFeature.MetricbeatMigration)) {
    return false;
  }
  if (!setupMode.data) {
    return false;
  }
  if (!product) {
    return false;
  }
  const data = setupMode.data[product] || {};
  if (data.totalUniqueInstanceCount === 0) {
    return true;
  }
  if (data.totalUniqueInternallyCollectedCount === 0 && data.totalUniqueFullyMigratedCount === 0 && data.totalUniquePartiallyMigratedCount === 0) {
    return true;
  }
  return false;
}