"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompatibleLayer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_from_map = require("../../../../../application/jobs/new_job/job_from_map");
var _context = require("../../../common/context");
var _job_details = require("../../../common/job_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/job_creation/map/map_vis_layer_selection_flyout/layer/compatible_layer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CompatibleLayer = ({
  embeddable,
  layer,
  layerIndex
}) => {
  var _layer$dataView, _embeddable$timeRange, _layer$dataView2, _layer$splitFieldOpti;
  const [selectedSplitField, setSelectedSplitField] = (0, _react.useState)(null);
  const [createError, setCreateError] = (0, _react.useState)();
  const {
    services: {
      data,
      share,
      uiSettings,
      mlServices: {
        mlApi
      }
    }
  } = (0, _context.useMlFromLensKibanaContext)();
  const quickJobCreator = (0, _react.useMemo)(() => new _job_from_map.QuickGeoJobCreator(data.dataViews, uiSettings, data.query.timefilter.timefilter, share, mlApi),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [data, uiSettings]);
  const createGeoJobInWizard = (0, _react.useCallback)(() => {
    (0, _job_from_map.redirectToGeoJobWizard)(embeddable, layer.dataView.id, layer.geoField, layer.query, selectedSplitField, share);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [layer === null || layer === void 0 ? void 0 : (_layer$dataView = layer.dataView) === null || _layer$dataView === void 0 ? void 0 : _layer$dataView.id, embeddable, selectedSplitField]);
  const createGeoJob = (0, _react.useCallback)(async ({
    jobId,
    bucketSpan,
    startJob,
    runInRealTime
  }) => {
    try {
      const result = await quickJobCreator.createAndSaveGeoJob({
        jobId,
        bucketSpan,
        embeddable,
        startJob,
        runInRealTime,
        sourceDataView: layer.dataView,
        geoField: layer.geoField,
        layerLevelQuery: layer.query,
        splitField: selectedSplitField
      });
      return result;
    } catch (error) {
      var _error$message;
      // eslint-disable-next-line no-console
      console.error(error);
      setCreateError({
        text: _i18n.i18n.translate('xpack.ml.embeddables.geoJobFlyout.jobCreationError', {
          defaultMessage: 'Job could not be created.'
        }),
        errorText: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : error
      });
      return {
        jobCreated: {
          success: false
        },
        datafeedCreated: {
          success: false
        },
        jobOpened: {
          success: false
        },
        datafeedStarted: {
          success: false
        }
      };
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [quickJobCreator, embeddable, selectedSplitField]);
  const splitFieldSelection = (0, _react.useMemo)(() => {
    const selectedOptions = [];
    if (selectedSplitField) {
      selectedOptions.push({
        label: selectedSplitField,
        field: selectedSplitField
      });
    }
    return selectedOptions;
  }, [selectedSplitField]);
  const onSplitFieldChange = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      setSelectedSplitField(option.field);
    } else {
      setSelectedSplitField(null);
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    layerIndex: layerIndex,
    createADJob: createGeoJob,
    createADJobInWizard: createGeoJobInWizard,
    timeRange: (_embeddable$timeRange = embeddable.timeRange$) === null || _embeddable$timeRange === void 0 ? void 0 : _embeddable$timeRange.value,
    incomingCreateError: createError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "mlMapLayerCompatible",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.embeddables.geoJobFlyout.createJobCalloutTitle.multiMetric",
    defaultMessage: "The {geoField} field can be used to create a geo job for {sourceDataViewTitle}",
    values: {
      geoField: layer.geoField,
      sourceDataViewTitle: (_layer$dataView2 = layer.dataView) === null || _layer$dataView2 === void 0 ? void 0 : _layer$dataView2.getIndexPattern()
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  })))), (_layer$splitFieldOpti = layer.splitFieldOptions) !== null && _layer$splitFieldOpti !== void 0 && _layer$splitFieldOpti.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": 'mlGeoJobAdditionalSettingsButton',
    id: "additional-section",
    buttonContent: _i18n.i18n.translate('xpack.ml.embeddables.geoJobFlyout.createJobCallout.splitField.title', {
      defaultMessage: 'Optionally select a field to split the data'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.embeddables.geoJobFlyout.selectSplitField",
      defaultMessage: "Split field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: layer.splitFieldOptions,
    selectedOptions: splitFieldSelection,
    onChange: onSplitFieldChange,
    isClearable: true,
    "data-test-subj": "mlGeoJobSplitFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 19
    }
  })))) : null)));
};
exports.CompatibleLayer = CompatibleLayer;