"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActiveRoute = void 0;
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _locator = require("../../../common/constants/locator");
var _app = require("../../../common/constants/app");
var _kibana = require("../contexts/kibana");
var _locator2 = require("../../locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/use_active_route.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Provides an active route of the ML app.
 * @param routesList
 */
const useActiveRoute = routesList => {
  var _activeRoute$path;
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    services: {
      executionContext,
      overlays,
      ...startServices
    }
  } = (0, _kibana.useMlKibana)();

  /**
   * Temp fix for routes with params.
   */
  const editCalendarMatch = (0, _reactRouterDom.useRouteMatch)(`/${_locator2.ML_PAGES.CALENDARS_EDIT}/:calendarId`);
  const editCalendarDstMatch = (0, _reactRouterDom.useRouteMatch)(`/${_locator2.ML_PAGES.CALENDARS_DST_EDIT}/:calendarId`);
  const editFilterMatch = (0, _reactRouterDom.useRouteMatch)(`/${_locator2.ML_PAGES.FILTER_LISTS_EDIT}/:filterId`);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const routesMap = (0, _react.useMemo)(() => (0, _lodash.keyBy)(routesList, 'path'), []);
  const activeRoute = (0, _react.useMemo)(() => {
    if (editCalendarMatch) {
      return routesMap[editCalendarMatch.path];
    }
    if (editCalendarDstMatch) {
      return routesMap[editCalendarDstMatch.path];
    }
    if (editFilterMatch) {
      return routesMap[editFilterMatch.path];
    }
    // Remove trailing slash from the pathname
    const pathnameKey = pathname.replace(/\/$/, '');
    // Treat empty pathname as root
    return routesMap[pathnameKey === '' ? '/' : pathnameKey];
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [pathname]);
  const bannerId = (0, _react.useRef)();
  (0, _react.useEffect)(function handleNotFoundRoute() {
    // For these deprecated routes, we already direct to the management page in the ml_page.tsx
    // so no need to show banner
    if (Object.keys(_locator.DEPRECATED_ML_ROUTE_TO_NEW_ROUTE).some(
    // paths include /, so need to convert `/jobs` -> `jobs`
    path => path === pathname.split('/')[1])) {
      return;
    }
    if (!activeRoute && !!pathname) {
      bannerId.current = overlays.banners.replace(bannerId.current, (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "warning",
        iconType: "info",
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.notFoundPage.title",
          defaultMessage: "Page Not Found",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 17
          }
        }),
        "data-test-subj": 'mlPageNotFoundBanner',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": 'mlPageNotFoundBannerText',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.notFoundPage.bannerText",
        defaultMessage: "The Machine Learning application doesn't recognize this route: {route}. You've been redirected to the Overview page.",
        values: {
          route: pathname
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 17
        }
      }))), startServices));

      // hide the message after the user has had a chance to acknowledge it -- so it doesn't permanently stick around
      setTimeout(() => {
        if (bannerId.current) {
          overlays.banners.remove(bannerId.current);
        }
      }, 15000);
    }
  }, [activeRoute, overlays, pathname, startServices]);
  (0, _public.useExecutionContext)(executionContext, {
    name: _app.PLUGIN_ID,
    type: 'application',
    page: (_activeRoute$path = activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path) !== null && _activeRoute$path !== void 0 ? _activeRoute$path : '/overview',
    id: activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path
  });
  return activeRoute !== null && activeRoute !== void 0 ? activeRoute : routesMap['/overview'];
};
exports.useActiveRoute = useActiveRoute;