"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareDetector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _detector_cards = require("./detector_cards");
var _rare_view = require("../rare_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/rare_detector/rare_detector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RareDetector = ({
  onChange
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [rareDetectorType, setRareDetectorType] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (jobCreator.rareField !== null) {
      if (jobCreator.populationField === null) {
        setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE);
      } else {
        setRareDetectorType(jobCreator.frequentlyRare ? _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION : _rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION);
      }
    } else {
      setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (rareDetectorType !== null) {
      onChange(rareDetectorType);
      if (rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE && jobCreator.populationField !== null) {
        jobCreator.removePopulationField();
      }
      jobCreator.frequentlyRare = rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION;
      jobCreatorUpdate();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [rareDetectorType]);
  function onRareSelection() {
    setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE);
  }
  function onRareInPopulationSelection() {
    setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION);
  }
  function onFreqRareInPopulationSelection() {
    setRareDetectorType(_rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.title",
    defaultMessage: "Rare detector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    style: {
      maxWidth: '824px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_detector_cards.RareCard, {
    onClick: onRareSelection,
    isSelected: rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_detector_cards.RareInPopulationCard, {
    onClick: onRareInPopulationSelection,
    isSelected: rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE_POPULATION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_detector_cards.FrequentlyRareInPopulationCard, {
    onClick: onFreqRareInPopulationSelection,
    isSelected: rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.FREQ_RARE_POPULATION,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })));
};
exports.RareDetector = RareDetector;