"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupsInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_creator_context = require("../../../job_creator_context");
var _group_color_utils = require("../../../../../../../../../common/util/group_color_utils");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/job_details_step/components/groups/groups_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupsInput = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    existingJobsAndGroups
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [selectedGroups, setSelectedGroups] = (0, _react.useState)(jobCreator.groups);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'groupsInput'
  });
  const validation = (0, _react.useMemo)(() => {
    var _jobValidator$latestV, _jobValidator$groupId, _jobValidator$latestV2;
    const valid = jobValidator.groupIds.valid === true && ((_jobValidator$latestV = jobValidator.latestValidationResult.groupIdsExist) === null || _jobValidator$latestV === void 0 ? void 0 : _jobValidator$latestV.valid) === true;
    const message = (_jobValidator$groupId = jobValidator.groupIds.message) !== null && _jobValidator$groupId !== void 0 ? _jobValidator$groupId : (_jobValidator$latestV2 = jobValidator.latestValidationResult.groupIdsExist) === null || _jobValidator$latestV2 === void 0 ? void 0 : _jobValidator$latestV2.message;
    return {
      valid,
      message
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  (0, _react.useEffect)(() => {
    jobCreator.groups = selectedGroups;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedGroups.join()]);
  const options = existingJobsAndGroups.groupIds.map(g => ({
    label: g,
    color: (0, _group_color_utils.tabColor)(g, euiTheme)
  }));
  const selectedOptions = selectedGroups.map(g => ({
    label: g,
    color: (0, _group_color_utils.tabColor)(g, euiTheme)
  }));
  function onChange(optionsIn) {
    setSelectedGroups(optionsIn.map(g => g.label));
  }
  function onCreateGroup(input, flattenedOptions) {
    const normalizedSearchValue = input.trim().toLowerCase();
    if (!normalizedSearchValue) {
      return;
    }
    const newGroup = {
      label: input,
      color: (0, _group_color_utils.tabColor)(input, euiTheme)
    };
    if (flattenedOptions.findIndex(option => option.label.trim().toLowerCase() === normalizedSearchValue) === -1) {
      options.push(newGroup);
    }
    setSelectedGroups([...selectedOptions, newGroup].map(g => g.label));
  }
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.jobGroupSelect.placeholder', {
      defaultMessage: 'Select or create groups'
    }),
    options: options,
    selectedOptions: selectedOptions,
    onChange: onChange,
    onCreateOption: onCreateGroup,
    isClearable: true,
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardComboBoxJobGroups",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
exports.GroupsInput = GroupsInput;