"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartLabelBadge = ExplorerChartLabelBadge;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/components/explorer_chart_label/explorer_chart_label_badge.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ExplorerChartLabelBadge({
  entity
}) {
  // Resets the badge's default strong font-weight so it's possible
  // to put custom emphasis inside the badge only on a part of it.
  // The entity's field_name will be styled as `normal` and field_value as `strong`.
  const resetFontWeightCss = (0, _react2.css)({
    fontWeight: 'normal'
  });
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    css: resetFontWeightCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 7
    }
  }, entity.fieldName, " ", /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 28
    }
  }, entity.fieldValue)));
}
ExplorerChartLabelBadge.propTypes = {
  entity: _propTypes.default.shape({
    fieldName: _propTypes.default.string.isRequired,
    fieldValue: _propTypes.default.string.isRequired
  })
};