"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _expanded_row_details_pane = require("./expanded_row_details_pane");
var _expanded_row_json_pane = require("./expanded_row_json_pane");
var _common = require("./common");
var _expanded_row_messages_pane = require("./expanded_row_messages_pane");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/analytics_list/expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getItemDescription(value) {
  if (typeof value === 'object') {
    return JSON.stringify(value);
  }
  return value.toString();
}
const ExpandedRow = ({
  item
}) => {
  var _item$config, _item$config$model_me, _item$config$version;
  const analysisType = (0, _mlDataFrameAnalyticsUtils.getAnalysisType)(item.config.analysis);
  const stateValues = {
    ...item.stats
  };
  const analysisStatsValues = stateValues.analysis_stats ? stateValues.analysis_stats[`${analysisType}_stats`] : undefined;
  if ((_item$config = item.config) !== null && _item$config !== void 0 && _item$config.description) {
    stateValues.description = item.config.description;
  }
  delete stateValues.progress;
  const dataCounts = {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.dataCounts', {
      defaultMessage: 'Data counts'
    }),
    items: [{
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.trainingDocsCount', {
        defaultMessage: 'Training docs'
      }),
      description: stateValues.data_counts.training_docs_count
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.testDocsCount', {
        defaultMessage: 'Test docs'
      }),
      description: stateValues.data_counts.test_docs_count
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.skippedDocsCount', {
        defaultMessage: 'Skipped docs'
      }),
      description: stateValues.data_counts.skipped_docs_count
    }],
    dataTestSubj: 'mlAnalyticsTableRowDetailsSection counts'
  };
  const memoryUsage = {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.memoryUsage', {
      defaultMessage: 'Memory usage'
    }),
    items: [{
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.timestamp', {
        defaultMessage: 'Timestamp'
      }),
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(stateValues.memory_usage.timestamp).unix() * 1000)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.peakUsageBytes', {
        defaultMessage: 'Peak usage bytes'
      }),
      description: stateValues.memory_usage.peak_usage_bytes
    }, {
      title: 'Status',
      description: stateValues.memory_usage.status
    }],
    dataTestSubj: 'mlAnalyticsTableRowDetailsSection stats'
  };
  const {
    currentPhase,
    totalPhases
  } = (0, _common.getDataFrameAnalyticsProgressPhase)(item.stats);
  const progress = {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.progressTitle', {
      defaultMessage: 'Phase {phase}',
      values: {
        phase: `${currentPhase}/${totalPhases}`
      }
    }),
    items: [...item.stats.progress.map(s => {
      return {
        title: s.phase,
        description: /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
          label: s.phase,
          valueText: true,
          value: s.progress_percent,
          max: 100,
          color: "primary",
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 13
          }
        })
      };
    })],
    dataTestSubj: 'mlAnalyticsTableRowDetailsSection progress'
  };
  const overallDetails = {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.stats', {
      defaultMessage: 'Overall'
    }),
    items: [{
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.status', {
        defaultMessage: 'Status'
      }),
      type: 'badge',
      description: stateValues.state
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.createTime', {
        defaultMessage: 'Create time'
      }),
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(item.config.create_time).unix() * 1000)
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.modelMemoryLimit', {
        defaultMessage: 'Model memory limit'
      }),
      description: (_item$config$model_me = item.config.model_memory_limit) !== null && _item$config$model_me !== void 0 ? _item$config$model_me : ''
    }, {
      title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.version', {
        defaultMessage: 'Version'
      }),
      description: (_item$config$version = item.config.version) !== null && _item$config$version !== void 0 ? _item$config$version : ''
    }],
    dataTestSubj: 'mlAnalyticsTableRowDetailsSection state'
  };
  const analysisStats = analysisStatsValues ? {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettings.analysisStats', {
      defaultMessage: 'Analysis stats'
    }),
    items: [{
      title: 'timestamp',
      description: (0, _mlDateUtils.formatHumanReadableDateTimeSeconds)((0, _momentTimezone.default)(analysisStatsValues.timestamp).unix() * 1000)
    }, {
      title: 'timing_stats',
      description: getItemDescription(analysisStatsValues.timing_stats)
    }, ...Object.entries(analysisStatsValues.parameters || analysisStatsValues.hyperparameters || {}).map(([stateKey, stateValue]) => {
      const title = stateKey.toString();
      return {
        title,
        description: getItemDescription(stateValue)
      };
    })],
    dataTestSubj: 'mlAnalyticsTableRowDetailsSection analysisStats'
  } : undefined;
  const tabs = [{
    id: 'ml-analytics-job-details',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.expandedRow.tabs.jobSettingsLabel', {
      defaultMessage: 'Details'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_details_pane.ExpandedRowDetailsPane, {
      overallDetails: overallDetails,
      dataCounts: dataCounts,
      memoryUsage: memoryUsage,
      analysisStats: analysisStats,
      progress: progress,
      dataTestSubj: `mlAnalyticsTableRowDetailsTabContent job-details ${item.config.id}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 9
      }
    }),
    'data-test-subj': `mlAnalyticsTableRowDetailsTab job-details ${item.config.id}`
  }, {
    id: 'ml-analytics-job-json',
    name: 'JSON',
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_json_pane.ExpandedRowJsonPane, {
      json: item.config,
      dataTestSubj: `mlAnalyticsTableRowDetailsTabContent json ${item.config.id}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 9
      }
    }),
    'data-test-subj': `mlAnalyticsTableRowDetailsTab json ${item.config.id}`
  }, {
    id: 'ml-analytics-job-messages',
    name: _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.analyticsDetails.tabs.analyticsMessagesLabel', {
      defaultMessage: 'Messages'
    }),
    content: /*#__PURE__*/_react.default.createElement(_expanded_row_messages_pane.ExpandedRowMessagesPane, {
      analyticsId: item.id,
      dataTestSubj: `mlAnalyticsTableRowDetailsTabContent job-messages ${item.config.id}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 9
      }
    }),
    'data-test-subj': `mlAnalyticsTableRowDetailsTab job-messages ${item.config.id}`
  }];

  // Using `expand=false` here so the tabs themselves don't spread
  // across the full width. The 100% width is used so the bottom line
  // as well as the tab content spans across the full width.
  // EuiTabbedContent would do that usually anyway,
  // it just doesn't seem to work within certain layouts.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0],
    onTabClick: () => {},
    expand: false,
    style: {
      width: '100%'
    },
    "data-test-subj": `mlAnalyticsTableRowDetails-${item.config.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 5
    }
  });
};
exports.ExpandedRow = ExpandedRow;