"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../contexts/kibana");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _analytics_service = require("../../services/analytics_service");
var _common = require("../analytics_list/common");
var _delete_action_name = require("./delete_action_name");
var _get_destination_index = require("../../../../common/get_destination_index");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_delete/use_delete_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DF_ANALYTICS_JOB_TYPE = 'data-frame-analytics';
const useDeleteAction = canDeleteDataFrameAnalytics => {
  const [item, setItem] = (0, _react.useState)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [isDeleteJobCheckModalVisible, setDeleteJobCheckModalVisible] = (0, _react.useState)(false);
  const [deleteItem, setDeleteItem] = (0, _react.useState)(false);
  const [deleteTargetIndex, setDeleteTargetIndex] = (0, _react.useState)(true);
  const [deleteDataView, setDeleteDataView] = (0, _react.useState)(true);
  const [userCanDeleteIndex, setUserCanDeleteIndex] = (0, _react.useState)(false);
  const [userCanDeleteDataView, setUserCanDeleteDataView] = (0, _react.useState)(false);
  const [dataViewExists, setDataViewExists] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    data: {
      dataViews
    },
    application: {
      capabilities
    }
  } = (0, _kibana.useMlKibana)().services;
  const indexName = (0, _get_destination_index.getDestinationIndex)(item === null || item === void 0 ? void 0 : item.config);
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const deleteAnalytics = (0, _analytics_service.useDeleteAnalytics)();
  const deleteAnalyticsAndDestIndex = (0, _analytics_service.useDeleteAnalyticsAndDestIndex)();
  const canDeleteIndex = (0, _analytics_service.useCanDeleteIndex)();
  const checkDataViewExists = async () => {
    try {
      const dv = (await dataViews.getIdsWithTitle(true)).find(({
        title
      }) => title === indexName);
      if (dv !== undefined) {
        setDataViewExists(true);
      } else {
        setDataViewExists(false);
      }
      setIsLoading(false);
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorMessage)(e);
      setIsLoading(false);
      toastNotificationService.displayDangerToast(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.errorWithCheckingIfDataViewExistsNotificationErrorMessage', {
        defaultMessage: 'An error occurred checking if data view {dataView} exists: {error}',
        values: {
          dataView: indexName,
          error
        }
      }));
    }
  };
  const checkUserIndexPermission = async () => {
    try {
      const userCanDelete = await canDeleteIndex(indexName);
      if (userCanDelete) {
        setUserCanDeleteIndex(true);
      }
      const canDeleteDataView = capabilities.savedObjectsManagement.delete === true || capabilities.indexPatterns.save === true;
      setUserCanDeleteDataView(canDeleteDataView);
      if (canDeleteDataView === false) {
        setDeleteDataView(false);
      }
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorMessage)(e);
      setIsLoading(false);
      toastNotificationService.displayDangerToast(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.errorWithCheckingIfUserCanDeleteIndexNotificationErrorMessage', {
        defaultMessage: 'An error occurred checking if user can delete {destinationIndex}: {error}',
        values: {
          destinationIndex: indexName,
          error
        }
      }));
    }
  };
  (0, _react.useEffect)(() => {
    setIsLoading(true);
    // Check if a data view exists corresponding to current DFA job
    // if data view does exist, show it to user
    checkDataViewExists();
    // Check if an user has permission to delete the index & data view
    checkUserIndexPermission();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isModalVisible]);
  const closeModal = () => setModalVisible(false);
  const closeDeleteJobCheckModal = () => setDeleteJobCheckModalVisible(false);
  const deleteAndCloseModal = () => {
    setDeleteItem(true);
    setModalVisible(false);
    if (item !== undefined) {
      if (userCanDeleteIndex && deleteTargetIndex || userCanDeleteIndex && deleteDataView) {
        deleteAnalyticsAndDestIndex(item.config, deleteTargetIndex, dataViewExists && deleteDataView);
      } else {
        deleteAnalytics(item.config);
      }
    }
  };
  const toggleDeleteIndex = () => setDeleteTargetIndex(!deleteTargetIndex);
  const toggleDeleteDataView = () => setDeleteDataView(!deleteDataView);
  const openModal = newItem => {
    setItem(newItem);
    setModalVisible(true);
  };
  const openDeleteJobCheckModal = newItem => {
    setItem(newItem);
    setDeleteJobCheckModalVisible(true);
  };
  const action = (0, _react.useMemo)(() => ({
    name: i => /*#__PURE__*/_react.default.createElement(_delete_action_name.DeleteActionName, {
      isDisabled: (0, _common.isDataFrameAnalyticsRunning)(i.stats.state) || !canDeleteDataFrameAnalytics,
      item: i,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }),
    enabled: i => !(0, _common.isDataFrameAnalyticsRunning)(i.stats.state) && canDeleteDataFrameAnalytics,
    description: _delete_action_name.deleteActionNameText,
    icon: 'trash',
    type: 'icon',
    onClick: i => openDeleteJobCheckModal(i),
    'data-test-subj': 'mlAnalyticsJobDeleteButton'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return {
    action,
    closeDeleteJobCheckModal,
    closeModal,
    deleteAndCloseModal,
    deleteTargetIndex,
    deleteDataView,
    deleteItem,
    dataViewExists,
    isDeleteJobCheckModalVisible,
    isModalVisible,
    isLoading,
    item,
    jobType: DF_ANALYTICS_JOB_TYPE,
    openModal,
    openDeleteJobCheckModal,
    toggleDeleteIndex,
    toggleDeleteDataView,
    userCanDeleteIndex,
    userCanDeleteDataView
  };
};
exports.useDeleteAction = useDeleteAction;