"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../../contexts/kibana");
var _custom_urls_description = require("../../../../../components/custom_urls/custom_urls_description");
var _custom_urls = require("../../../../../components/custom_urls");
var _state = require("../../../analytics_management/hooks/use_create_analytics_form/state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/details_step/additional_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buttonContent = _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.detailsStep.additionalSectionButton', {
  defaultMessage: 'Additional settings'
});
const AdditionalSection = ({
  formState,
  setFormState
}) => {
  var _formMeta$custom_urls;
  const [additionalExpanded, setAdditionalExpanded] = (0, _react.useState)(false);
  const {
    _meta: formMeta
  } = formState;
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const docsUrl = docLinks.links.ml.customUrls;
  const analyticsJob = (0, _react.useMemo)(() => (0, _state.getJobConfigFromFormState)(formState), [formState]);
  const setCustomUrls = urls => {
    setFormState({
      _meta: {
        ...formMeta,
        custom_urls: urls
      }
    });
  };
  const description = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.create.detailsStep.additionalSection.customUrlsSelection.description",
    defaultMessage: "Provide links from analytics job results to Kibana dashboards, Discover, or other web pages. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docsUrl,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.create.detailsStep.additionalSection.customUrlsSelection.learnMoreLinkText",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), [docsUrl]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "additional-section",
    buttonContent: buttonContent,
    onToggle: setAdditionalExpanded,
    initialIsOpen: additionalExpanded,
    "data-test-subj": "mlJobWizardToggleAdditionalSettingsSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("section", {
    "data-test-subj": "mlDataFrameAnalyticsDetailsStepAdditionalSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_custom_urls_description.CustomUrlsDescription, {
    description: description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_urls.CustomUrlsWrapper, {
    job: analyticsJob,
    jobCustomUrls: (_formMeta$custom_urls = formMeta === null || formMeta === void 0 ? void 0 : formMeta.custom_urls) !== null && _formMeta$custom_urls !== void 0 ? _formMeta$custom_urls : [],
    setCustomUrls: setCustomUrls,
    editMode: "modal",
    isPartialDFAJob: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })))));
};
exports.AdditionalSection = AdditionalSection;