"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RecognizedResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _link_card = require("../link_card");
var _kibana = require("../../contexts/kibana");
var _locator = require("../../../../common/constants/locator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/data_recognizer/recognized_result.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RecognizedResult = ({
  config,
  indexPattern,
  savedSearch
}) => {
  const id = savedSearch === null ? `index=${indexPattern.id}` : `savedSearchId=${savedSearch.id}`;
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const navigateToCreateJobRecognizerPath = async () => {
    if (!mlManagementLocator) return;
    await mlManagementLocator.navigate({
      sectionId: 'ml',
      appId: `anomaly_detection/${_locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER}?id=${config.id}&${id}`
    });
  };
  let logo = null;
  // if a logo is available, use that, otherwise display the id
  // the logo should be a base64 encoded image or an eui icon
  if (config.logo && config.logo.icon) {
    logo = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: config.logo.icon,
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 12
      }
    });
  } else if (config.logo && config.logo.src) {
    logo = /*#__PURE__*/_react.default.createElement("img", {
      alt: "",
      src: config.logo.src,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 12
      }
    });
  } else {
    logo = /*#__PURE__*/_react.default.createElement("h3", {
      className: "euiTitle euiTitle--small",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 12
      }
    }, config.id);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_link_card.LinkCard, {
    "data-test-subj": `mlRecognizerCard ${config.id}`,
    onClick: navigateToCreateJobRecognizerPath,
    title: config.title,
    description: config.description,
    icon: logo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }));
};
exports.RecognizedResult = RecognizedResult;
RecognizedResult.propTypes = {
  config: _propTypes.default.object,
  indexPattern: _propTypes.default.object,
  savedSearch: _propTypes.default.object
};