"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimeFunction = isTimeFunction;
exports.useTimeValueInfo = useTimeValueInfo;
var _common = require("@kbn/field-formats-plugin/common");
var _format_value = require("../../formatters/format_value");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard to check if a function is a time-based function
 */
function isTimeFunction(functionName) {
  return functionName === 'time_of_day' || functionName === 'time_of_week';
}

/**
 * Gets formatted time information for time-based functions
 */
function useTimeValueInfo(value, functionName, record) {
  const dateFormatter = (0, _kibana.useFieldFormatter)(_common.FIELD_FORMAT_IDS.DATE);
  if (!isTimeFunction(functionName)) {
    return null;
  }
  const result = (0, _format_value.formatTimeValue)(value, functionName, record);

  // Create a more detailed tooltip format using the moment object
  const tooltipContent = dateFormatter(result.moment.valueOf());
  return {
    formattedTime: result.formatted,
    tooltipContent,
    dayOffset: result.dayOffset
  };
}