"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTSingleLayerVectorSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _mvt_single_layer_source_settings = require("./mvt_single_layer_source_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/mvt_single_layer_vector_source/mvt_single_layer_vector_source_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class MVTSingleLayerVectorSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      urlTemplate: '',
      layerName: '',
      minSourceZoom: _constants.MIN_ZOOM,
      maxSourceZoom: _constants.MAX_ZOOM,
      fields: []
    });
    (0, _defineProperty2.default)(this, "_sourceConfigChange", _lodash.default.debounce(() => {
      const canPreview = this.state.urlTemplate.indexOf('{x}') >= 0 && this.state.urlTemplate.indexOf('{y}') >= 0 && this.state.urlTemplate.indexOf('{z}') >= 0;
      if (canPreview && this.state.layerName) {
        this.props.onSourceConfigChange({
          urlTemplate: this.state.urlTemplate,
          layerName: this.state.layerName,
          minSourceZoom: this.state.minSourceZoom,
          maxSourceZoom: this.state.maxSourceZoom,
          fields: this.state.fields
        });
      }
    }, 200));
    (0, _defineProperty2.default)(this, "_handleUrlTemplateChange", e => {
      const url = e.target.value;
      this.setState({
        urlTemplate: url
      }, () => this._sourceConfigChange());
    });
    (0, _defineProperty2.default)(this, "_handleChange", state => {
      this.setState(state, () => this._sourceConfigChange());
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.urlMessage', {
        defaultMessage: 'Url'
      }),
      helpText: _i18n.i18n.translate('xpack.maps.source.MVTSingleLayerVectorSourceEditor.urlHelpMessage', {
        defaultMessage: 'URL of the .mvt vector tile service. e.g. {url}',
        values: {
          url: 'http://company.com/{z}/{x}/{y}.pbf'
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.urlTemplate,
      onChange: this._handleUrlTemplateChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_mvt_single_layer_source_settings.MVTSingleLayerSourceSettings, {
      handleChange: this._handleChange,
      layerName: this.state.layerName,
      fields: this.state.fields,
      minSourceZoom: this.state.minSourceZoom,
      maxSourceZoom: this.state.maxSourceZoom,
      showFields: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }));
  }
}
exports.MVTSingleLayerVectorSourceEditor = MVTSingleLayerVectorSourceEditor;