"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupByButtonGroup = GroupByButtonGroup;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18n_constants = require("./i18n_constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_line_source/geo_line_form/group_by_button_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GROUP_BY_TIME_SERIES = 'timeseries';
const GROUP_BY_TERM = 'terms';
const GROUP_BY_OPTIONS = [{
  id: GROUP_BY_TIME_SERIES,
  label: _i18n_constants.TIME_SERIES_LABEL
}, {
  id: GROUP_BY_TERM,
  label: _i18n_constants.TERMS_LABEL
}];
function GroupByButtonGroup({
  groupByTimeseries,
  onGroupByTimeseriesChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "single",
    legend: _i18n.i18n.translate('xpack.maps.source.esGeoLine.groupByButtonGroupLegend', {
      defaultMessage: 'Choose group by method'
    }),
    options: GROUP_BY_OPTIONS,
    idSelected: groupByTimeseries ? GROUP_BY_TIME_SERIES : GROUP_BY_TERM,
    onChange: id => {
      onGroupByTimeseriesChange(id === GROUP_BY_TIME_SERIES);
    },
    isFullWidth: true,
    buttonSize: "compressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  });
}