"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rxjs = require("rxjs");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _services = require("../services");
var _pipeline_list = require("./components/pipeline_list");
var _pipeline_edit_view = require("./pipeline_edit_view");
var Breadcrumbs = _interopRequireWildcard(require("./breadcrumbs"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/logstash/public/application/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderApp = async (core, {
  history,
  element,
  setBreadcrumbs
}, isMonitoringEnabled, licenseService$, isServerless) => {
  const logstashLicenseService = await licenseService$.pipe((0, _rxjs.first)()).toPromise();
  const clusterService = new _services.ClusterService(core.http);
  const monitoringService = new _services.MonitoringService(core.http, isMonitoringEnabled, clusterService);
  const pipelinesService = new _services.PipelinesService(core.http, monitoringService);
  const pipelineService = new _services.PipelineService(core.http, pipelinesService);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ['/', ''],
    exact: true,
    render: () => {
      setBreadcrumbs(Breadcrumbs.getPipelineListBreadcrumbs());
      return /*#__PURE__*/_react.default.createElement(_pipeline_list.PipelineList, {
        clusterService: clusterService,
        isServerless: isServerless,
        isReadOnly: logstashLicenseService.isReadOnly,
        isForbidden: true,
        isLoading: false,
        licenseService: logstashLicenseService,
        monitoringService: monitoringService,
        openPipeline: id => history.push(`/pipeline/${id}/edit`),
        clonePipeline: id => history.push(`/pipeline/${id}/edit?clone`),
        createPipeline: () => history.push(`pipeline/new-pipeline`),
        pipelinesService: pipelinesService,
        toastNotifications: core.notifications.toasts,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 17
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/pipeline/new-pipeline",
    exact: true,
    render: () => /*#__PURE__*/_react.default.createElement(_pipeline_edit_view.PipelineEditView, {
      history: history,
      setBreadcrumbs: setBreadcrumbs,
      logstashLicenseService: logstashLicenseService,
      pipelineService: pipelineService,
      toasts: core.notifications.toasts,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/pipeline/:id",
    exact: true,
    render: ({
      match
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: `/pipeline/${match.params.id}/edit`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 36
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/pipeline/:id/edit",
    exact: true,
    render: ({
      match
    }) => /*#__PURE__*/_react.default.createElement(_pipeline_edit_view.PipelineEditView, {
      history: history,
      setBreadcrumbs: setBreadcrumbs,
      logstashLicenseService: logstashLicenseService,
      pipelineService: pipelineService,
      toasts: core.notifications.toasts,
      id: match.params.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;