"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDimensionEditor = DataDimensionEditor;
exports.DataDimensionEditorDataSectionExtra = DataDimensionEditorDataSectionExtra;
exports.idPrefix = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _visualizationUtils = require("@kbn/visualization-utils");
var _visualizationUiComponents = require("@kbn/visualization-ui-components");
var _eui = require("@elastic/eui");
var _coloring = require("@kbn/coloring");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _palettes = require("@kbn/palettes");
var _state_helpers = require("../state_helpers");
var _visualization_helpers = require("../visualization_helpers");
var _collapse_setting = require("../../../shared_components/collapse_setting");
var _to_expression = require("../to_expression");
var _color_assignment = require("../color_assignment");
var _color_mapping_by_terms = require("../../../shared_components/coloring/color_mapping_by_terms");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/xy/xy_config_panel/dimension_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const idPrefix = exports.idPrefix = (0, _eui.htmlIdGenerator)()();
function updateLayer(state, index, layer, newLayer) {
  const newLayers = [...state.layers];
  newLayers[index] = {
    ...layer,
    ...newLayer
  };
  return newLayers;
}
function DataDimensionEditor(props) {
  var _layer$yConfig;
  const {
    state,
    layerId,
    accessor,
    isDarkMode,
    isInlineEditing
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const updateLayerState = (0, _react.useCallback)((layerIndex, newLayer) => {
    setLocalState({
      ...localState,
      layers: updateLayer(localState, layerIndex, layer, newLayer)
    });
  }, [layer, setLocalState, localState]);
  const localYConfig = layer === null || layer === void 0 ? void 0 : (_layer$yConfig = layer.yConfig) === null || _layer$yConfig === void 0 ? void 0 : _layer$yConfig.find(yAxisConfig => yAxisConfig.forAccessor === accessor);
  const axisMode = (localYConfig === null || localYConfig === void 0 ? void 0 : localYConfig.axisMode) || 'auto';
  const setConfig = (0, _react.useCallback)(yConfig => {
    if (yConfig == null) {
      return;
    }
    const newYConfigs = [...(layer.yConfig || [])];
    const existingIndex = newYConfigs.findIndex(yAxisConfig => yAxisConfig.forAccessor === accessor);
    if (existingIndex !== -1) {
      newYConfigs[existingIndex] = {
        ...newYConfigs[existingIndex],
        ...yConfig
      };
    } else {
      newYConfigs.push({
        forAccessor: accessor,
        ...yConfig
      });
    }
    updateLayerState(index, {
      yConfig: newYConfigs
    });
  }, [layer.yConfig, updateLayerState, index, accessor]);
  const setColorMapping = (0, _react.useCallback)(colorMapping => {
    updateLayerState(index, {
      colorMapping
    });
  }, [updateLayerState, index]);
  const setPalette = (0, _react.useCallback)(palette => {
    updateLayerState(index, {
      palette,
      colorMapping: undefined
    });
  }, [updateLayerState, index]);
  const overwriteColor = (0, _state_helpers.getSeriesColor)(layer, accessor);
  const assignedColor = (0, _react.useMemo)(() => {
    var _props$frame$activeDa;
    const sortedAccessors = (0, _to_expression.getSortedAccessors)(props.frame.datasourceLayers[layer.layerId], layer);
    const colorAssignments = (0, _color_assignment.getColorAssignments)((0, _visualization_helpers.getDataLayers)(state.layers), {
      tables: (_props$frame$activeDa = props.frame.activeData) !== null && _props$frame$activeDa !== void 0 ? _props$frame$activeDa : {}
    }, props.formatFactory);
    return (0, _color_assignment.getAssignedColorConfig)({
      ...layer,
      accessors: sortedAccessors.filter(sorted => layer.accessors.includes(sorted))
    }, accessor, colorAssignments, props.frame, props.paletteService).color;
  }, [props.frame, props.paletteService, state.layers, accessor, props.formatFactory, layer]);
  if (props.groupId === 'breakdown') {
    var _props$frame$activeDa2, _currentData$columns, _currentData$columns$;
    const currentData = (_props$frame$activeDa2 = props.frame.activeData) === null || _props$frame$activeDa2 === void 0 ? void 0 : _props$frame$activeDa2[layer.layerId];
    const splitCategories = (0, _chartExpressionsCommon.getColorCategories)(currentData === null || currentData === void 0 ? void 0 : currentData.rows, layer.splitAccessor);
    const columnMeta = currentData === null || currentData === void 0 ? void 0 : (_currentData$columns = currentData.columns) === null || _currentData$columns === void 0 ? void 0 : (_currentData$columns$ = _currentData$columns.find(({
      id
    }) => id === layer.splitAccessor)) === null || _currentData$columns$ === void 0 ? void 0 : _currentData$columns$.meta;
    const allowCustomMatch = (0, _coloring.canCreateCustomMatch)(columnMeta);
    const formatter = props.formatFactory(columnMeta === null || columnMeta === void 0 ? void 0 : columnMeta.params);
    return !layer.collapseFn ? /*#__PURE__*/_react.default.createElement(_color_mapping_by_terms.ColorMappingByTerms, {
      isDarkMode: isDarkMode,
      colorMapping: layer.colorMapping,
      palette: layer.palette,
      isInlineEditing: isInlineEditing,
      setPalette: setPalette,
      setColorMapping: setColorMapping,
      paletteService: props.paletteService,
      palettes: props.palettes,
      panelRef: props.panelRef,
      categories: splitCategories,
      formatter: formatter,
      allowCustomMatch: allowCustomMatch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    }) : null;
  }
  const isHorizontal = (0, _state_helpers.isHorizontalChart)(state.layers);
  const disabledMessage = Boolean(!layer.collapseFn && layer.splitAccessor) ? _i18n.i18n.translate('xpack.lens.xyChart.colorPicker.tooltip.disabled', {
    defaultMessage: 'You are unable to apply custom colors to individual series when the layer includes a "Break down by" field.'
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUiComponents.ColorPicker, (0, _extends2.default)({}, props, {
    overwriteColor: overwriteColor,
    defaultColor: assignedColor,
    disabledMessage: disabledMessage,
    swatches: props.palettes.get(_palettes.KbnPalette.Default).colors(10),
    setConfig: setConfig,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.label', {
      defaultMessage: 'Axis side'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.label', {
      defaultMessage: 'Axis side'
    }),
    "data-test-subj": "lnsXY_axisSide_groups",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}left`,
      label: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.axisSide.bottom', {
        defaultMessage: 'Bottom'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.axisSide.left', {
        defaultMessage: 'Left'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_left'
    }, {
      id: `${idPrefix}auto`,
      label: _i18n.i18n.translate('xpack.lens.xyChart.axisSide.auto', {
        defaultMessage: 'Auto'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_auto'
    }, {
      id: `${idPrefix}right`,
      label: isHorizontal ? _i18n.i18n.translate('xpack.lens.xyChart.axisSide.top', {
        defaultMessage: 'Top'
      }) : _i18n.i18n.translate('xpack.lens.xyChart.axisSide.right', {
        defaultMessage: 'Right'
      }),
      'data-test-subj': 'lnsXY_axisSide_groups_right'
    }],
    idSelected: `${idPrefix}${axisMode}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setConfig({
        axisMode: newMode
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  })));
}
function DataDimensionEditorDataSectionExtra(props) {
  const {
    state,
    layerId
  } = props;
  const index = state.layers.findIndex(l => l.layerId === layerId);
  const layer = state.layers[index];
  const {
    inputValue: localState,
    handleInputChange: setLocalState
  } = (0, _visualizationUtils.useDebouncedValue)({
    value: props.state,
    onChange: props.setState
  });
  const updateLayerState = (0, _react.useCallback)((layerIndex, newLayer) => {
    setLocalState({
      ...localState,
      layers: updateLayer(localState, layerIndex, layer, newLayer)
    });
  }, [layer, setLocalState, localState]);
  if (props.groupId === 'breakdown') {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapse_setting.CollapseSetting, {
      value: layer.collapseFn || '',
      onChange: collapseFn => {
        updateLayerState(index, {
          collapseFn
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 9
      }
    }));
  }
  return null;
}