"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApiESQLVariablesCompatible = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

/**
 * This visualization context can have a different attributes than the
 * one stored in the Lens API attributes
 */

/**
 * Lens embeddable props broken down by type
 */

/**
 * Public Callbacks are function who are exposed thru the Lens custom renderer component,
 * so not directly exposed in the Lens API, rather passed down as parentApi to the Lens Embeddable
 */

/**
 * API callbacks are function who are used by direct Embeddable consumers (i.e. Dashboard or our own Lens custom renderer)
 */

/**
 * This set of props are exposes by the Lens component too
 */

/**
 * Compose together all the props and make them inspectable via Simplify
 *
 * The LensSerializedState is the state stored for a dashboard panel
 * that contains:
 * * Lens document state
 * * Panel settings
 * * other props from the embeddable
 */

/**
 * Custom props exposed on the Lens exported component
 */

/**
 * This is the subset of props that from the LensComponent will be forwarded to the Lens embeddable
 */

/**
 * Carefully chosen props to expose on the Lens renderer component used by
 * other plugins
 */

/**
 * The LensRuntimeState is the state stored for a dashboard panel
 * that contains:
 * * Lens document state
 * * Panel settings
 * * other props from the embeddable
 */

// This is an API only used internally to the embeddable but not exported elsewhere
// there's some overlapping between this and the LensApi but they are shared references

/** Utility type to build typed version for each chart */

/**
 * Type-safe variant of by value embeddable input for Lens.
 * This can be used to hardcode certain Lens chart configurations within another app.
 */

/**
 * Backward compatibility types
 */

const isApiESQLVariablesCompatible = api => {
  return Boolean(api && (api === null || api === void 0 ? void 0 : api.esqlVariables$) !== undefined && (api === null || api === void 0 ? void 0 : api.controlGroupApi$) !== undefined && (api === null || api === void 0 ? void 0 : api.children$) !== undefined);
};
exports.isApiESQLVariablesCompatible = isApiESQLVariablesCompatible;