"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitializeChartFunction = void 0;
exports.useInitializeChart = useInitializeChart;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Encapsulates the logic for initializing the chart/data grid based on ESQL query.
 *
 */
const createInitializeChartFunction = ({
  isTextBasedLanguage,
  query,
  dataGridAttrs,
  isInitialized,
  currentAttributes,
  runQuery,
  prevQueryRef,
  setErrors,
  setIsInitialized
}) => {
  return async abortController => {
    if (isInitialized) {
      // If already initialized, do nothing
      return;
    }
    if (isTextBasedLanguage && (0, _esQuery.isOfAggregateQueryType)(query) && !dataGridAttrs) {
      try {
        const shouldUpdateAttrs = Boolean(currentAttributes === null || currentAttributes === void 0 ? void 0 : currentAttributes.state.needsRefresh);
        await runQuery(query, abortController, shouldUpdateAttrs);
      } catch (e) {
        setErrors([e]);
      }
      prevQueryRef.current = query;
    }
    setIsInitialized(true);
  };
};
exports.createInitializeChartFunction = createInitializeChartFunction;
function useInitializeChart({
  isTextBasedLanguage,
  query,
  dataGridAttrs,
  isInitialized,
  currentAttributes,
  runQuery,
  prevQueryRef,
  setErrors,
  setIsInitialized
}) {
  const initializeChartFunc = (0, _react.useCallback)(() => {
    const abortController = new AbortController();
    const func = createInitializeChartFunction({
      isTextBasedLanguage,
      query,
      dataGridAttrs,
      isInitialized,
      currentAttributes,
      runQuery,
      prevQueryRef,
      setErrors,
      setIsInitialized
    });
    func(abortController);
  }, [isTextBasedLanguage, query, dataGridAttrs, isInitialized, currentAttributes, runQuery, prevQueryRef, setErrors, setIsInitialized]);
  (0, _react.useEffect)(() => {
    initializeChartFunc();
  }, [initializeChartFunc]);
}