"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToOriginalColumnsTextBased = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapToOriginalColumnsTextBased = (data, {
  idMap: encodedIdMap
}) => {
  const isOriginalColumn = item => {
    return !!item;
  };
  const idMap = JSON.parse(encodedIdMap);

  // extract all the entries once
  const idMapColEntries = Object.entries(idMap);
  // create a lookup id => column
  const colLookups = new Map(data.columns.map(c => [c.id, c]));

  // now create a lookup to get the original columns for each variable
  const colVariableLookups = new Map(idMapColEntries.flatMap(([id, columns]) => columns.filter(({
    variable
  }) => variable).map(({
    variable
  }) => [`${variable}`, columns])));
  return {
    ...data,
    rows: data.rows.map(row => {
      const mappedRow = {};
      for (const id in row) {
        if (id in idMap) {
          for (const cachedEntry of idMap[id]) {
            mappedRow[cachedEntry.id] = row[id];
          }
        } else {
          const col = colLookups.get(id);
          if (col !== null && col !== void 0 && col.variable) {
            const originalColumn = colVariableLookups.get(col.variable);
            if (originalColumn) {
              for (const cachedEntry of originalColumn) {
                mappedRow[cachedEntry.id] = row[id];
              }
            }
          }
        }
      }
      return mappedRow;
    }),
    columns: data.columns.flatMap(column => {
      if (!(column.id in idMap) && !column.variable) {
        return [];
      }
      if (column.variable) {
        const originalColumn = idMapColEntries.map(([_id, columns]) => columns.find(c => c.variable === column.variable)).filter(isOriginalColumn);
        if (!originalColumn) {
          return [];
        }
        return originalColumn.map(c => ({
          ...column,
          id: c.id
        }));
      }
      return idMap[column.id].map(originalColumn => {
        var _column$meta$sourcePa, _column$meta;
        return {
          ...column,
          id: originalColumn.id,
          name: originalColumn.label,
          meta: {
            ...column.meta,
            ...('sourceField' in originalColumn ? {
              field: originalColumn.sourceField
            } : {}),
            ...('format' in originalColumn ? {
              params: originalColumn.format
            } : {}),
            sourceParams: {
              ...((_column$meta$sourcePa = (_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.sourceParams) !== null && _column$meta$sourcePa !== void 0 ? _column$meta$sourcePa : {}),
              ...('sourceField' in originalColumn ? {
                sourceField: originalColumn.sourceField
              } : {}),
              ...('operationType' in originalColumn ? {
                operationType: originalColumn.operationType
              } : {}),
              ...('interval' in originalColumn ? {
                interval: originalColumn.interval
              } : {}),
              ...('params' in originalColumn ? {
                params: {
                  ...originalColumn.params,
                  used_interval: `${originalColumn.interval}ms`
                }
              } : {})
            }
          }
        };
      });
    })
  };
};
exports.mapToOriginalColumnsTextBased = mapToOriginalColumnsTextBased;