"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  /** Controls whether inspect component plugin is enabled. */
  enabled: _configSchema.schema.conditional(_configSchema.schema.contextRef('dev'), true, /** Allowed to be configured when in dev. */
  _configSchema.schema.boolean(), /** When not in dev, only false is allowed. */
  _configSchema.schema.literal(false), /** Default to false, even in dev */
  {
    defaultValue: false
  })
});