"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTimeControls = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/data-plugin/public");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_kibana_ui_setting = require("../../../../hooks/use_kibana_ui_setting");
var _map_timepicker_quickranges_to_datepicker_ranges = require("../../../../utils/map_timepicker_quickranges_to_datepicker_ranges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/time_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricsTimeControls = props => {
  const [timepickerQuickRanges] = (0, _use_kibana_ui_setting.useKibanaUiSetting)(_public.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const {
    onChangeTimeRange,
    onRefresh,
    currentTimeRange,
    isLiveStreaming,
    refreshInterval,
    setAutoReload,
    setRefreshInterval
  } = props;
  const commonlyUsedRanges = (0, _map_timepicker_quickranges_to_datepicker_ranges.mapKibanaQuickRangesToDatePickerRanges)(timepickerQuickRanges);
  const handleTimeChange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    onChangeTimeRange({
      from: start,
      to: end,
      interval: '>=1m'
    });
  }, [onChangeTimeRange]);
  const handleRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval: _refreshInterval
  }) => {
    if (isPaused) {
      setAutoReload(false);
    } else {
      setRefreshInterval(_refreshInterval);
      setAutoReload(true);
    }
  }, [setAutoReload, setRefreshInterval]);
  return /*#__PURE__*/_react.default.createElement(MetricsTimeControlsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: currentTimeRange.from.toString(),
    end: currentTimeRange.to.toString(),
    isPaused: !isLiveStreaming,
    refreshInterval: refreshInterval ? refreshInterval : 0,
    onTimeChange: handleTimeChange,
    onRefreshChange: handleRefreshChange,
    onRefresh: onRefresh,
    commonlyUsedRanges: commonlyUsedRanges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
};
exports.MetricsTimeControls = MetricsTimeControls;
const MetricsTimeControlsContainer = _styled.default.div`
  max-width: 750px;
`;