"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KubernetesTour = exports.KUBERNETES_TOUR_STORAGE_KEY = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/kubernetes_tour.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KUBERNETES_TOUR_STORAGE_KEY = exports.KUBERNETES_TOUR_STORAGE_KEY = 'isKubernetesTourSeen';
const dismissLabel = _i18n.i18n.translate('xpack.infra.homePage.kubernetesTour.dismiss', {
  defaultMessage: 'Dismiss'
});
const KubernetesTour = ({
  children
}) => {
  const [isTourSeen, setIsTourSeen] = (0, _useLocalStorage.default)(KUBERNETES_TOUR_STORAGE_KEY, false);
  const markTourAsSeen = () => setIsTourSeen(true);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      "data-test-subj": "infra-kubernetesTour-text",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.infra.homePage.kubernetesTour.text', {
      defaultMessage: 'Click here to see your infrastructure in different ways, including Kubernetes pods.'
    })),
    isStepOpen: !isTourSeen,
    maxWidth: 350,
    onFinish: markTourAsSeen,
    step: 1,
    stepsTotal: 1,
    title: _i18n.i18n.translate('xpack.infra.homePage.kubernetesTour.title', {
      defaultMessage: 'Want a different view?'
    }),
    anchorPosition: "downCenter",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": dismissLabel,
      "data-test-subj": "infra-kubernetesTour-dismiss",
      size: "s",
      color: "text",
      onClick: markTourAsSeen,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }, dismissLabel),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, children);
};
exports.KubernetesTour = KubernetesTour;