"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryDetailsRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _use_log_entry_category_examples = require("../../use_log_entry_category_examples");
var _log_entry_examples = require("../../../../../components/logging/log_entry_examples/log_entry_examples");
var _category_example_message = require("./category_example_message");
var _use_log_ml_job_id_formats_shim = require("../../../shared/use_log_ml_job_id_formats_shim");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/sections/top_categories/category_details_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const exampleCount = 5;
const CategoryDetailsRow = ({
  categoryId,
  timeRange,
  logViewReference
}) => {
  const {
    idFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();
  const {
    getLogEntryCategoryExamples,
    hasFailedLoadingLogEntryCategoryExamples,
    isLoadingLogEntryCategoryExamples,
    logEntryCategoryExamples
  } = (0, _use_log_entry_category_examples.useLogEntryCategoryExamples)({
    categoryId,
    endTime: timeRange.endTime,
    exampleCount,
    logViewReference,
    idFormat: idFormats === null || idFormats === void 0 ? void 0 : idFormats[_log_analysis.logEntryCategoriesJobType],
    startTime: timeRange.startTime
  });
  (0, _react.useEffect)(() => {
    getLogEntryCategoryExamples();
  }, [getLogEntryCategoryExamples]);
  const formattedExamples = logEntryCategoryExamples.map(example => ({
    id: example.id,
    dataset: example.dataset,
    message: example.message,
    timestamp: example.timestamp,
    tiebreaker: example.tiebreaker,
    context: example.context
  }));
  return /*#__PURE__*/_react.default.createElement(_log_entry_examples.LogEntryExampleMessages, {
    isLoading: isLoadingLogEntryCategoryExamples,
    hasFailedLoading: hasFailedLoadingLogEntryCategoryExamples,
    hasResults: logEntryCategoryExamples.length > 0,
    exampleCount: exampleCount,
    onReload: getLogEntryCategoryExamples,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_category_example_message.CategoryExampleMessageTable, {
    key: categoryId,
    examples: formattedExamples,
    timeRange: timeRange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.CategoryDetailsRow = CategoryDetailsRow;