"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostMetadataBySchema = exports.getContainerMetadata = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ecsHostExtendedMetadata = metadataInfo => {
  var _metadataInfo$cloud, _metadataInfo$host, _metadataInfo$host$os;
  return [{
    field: 'cloudProvider',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud = metadataInfo.cloud) === null || _metadataInfo$cloud === void 0 ? void 0 : _metadataInfo$cloud.provider,
    tooltipFieldLabel: 'cloud.provider',
    tooltipLink: 'https://www.elastic.co/guide/en/ecs/current/ecs-cloud.html#field-cloud-provider'
  }, {
    field: 'operatingSystem',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host = metadataInfo.host) === null || _metadataInfo$host === void 0 ? void 0 : (_metadataInfo$host$os = _metadataInfo$host.os) === null || _metadataInfo$host$os === void 0 ? void 0 : _metadataInfo$host$os.name,
    tooltipFieldLabel: 'host.os.name'
  }];
};
const ecsHostMetadataData = metadataInfo => {
  var _metadataInfo$host2, _metadataInfo$host3, _metadataInfo$host3$o;
  return [{
    field: 'hostIp',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host2 = metadataInfo.host) === null || _metadataInfo$host2 === void 0 ? void 0 : _metadataInfo$host2.ip,
    tooltipFieldLabel: 'host.ip',
    tooltipLink: 'https://www.elastic.co/guide/en/ecs/current/ecs-host.html#field-host-ip'
  }, {
    field: 'hostOsVersion',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host3 = metadataInfo.host) === null || _metadataInfo$host3 === void 0 ? void 0 : (_metadataInfo$host3$o = _metadataInfo$host3.os) === null || _metadataInfo$host3$o === void 0 ? void 0 : _metadataInfo$host3$o.version,
    tooltipFieldLabel: 'host.os.version'
  }];
};
const ecsContainerExtendedMetadata = metadataInfo => {
  var _metadataInfo$contain, _metadataInfo$cloud2, _metadataInfo$cloud2$, _metadataInfo$cloud3, _metadataInfo$cloud4;
  return [{
    field: 'runtime',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$contain = metadataInfo.container) === null || _metadataInfo$contain === void 0 ? void 0 : _metadataInfo$contain.runtime,
    tooltipFieldLabel: 'container.runtime'
  }, {
    field: 'cloudInstanceId',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud2 = metadataInfo.cloud) === null || _metadataInfo$cloud2 === void 0 ? void 0 : (_metadataInfo$cloud2$ = _metadataInfo$cloud2.instance) === null || _metadataInfo$cloud2$ === void 0 ? void 0 : _metadataInfo$cloud2$.id,
    tooltipFieldLabel: 'cloud.instance.id'
  }, {
    field: 'cloudImageId',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud3 = metadataInfo.cloud) === null || _metadataInfo$cloud3 === void 0 ? void 0 : _metadataInfo$cloud3.imageId,
    tooltipFieldLabel: 'cloud.image.id'
  }, {
    field: 'cloudProvider',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$cloud4 = metadataInfo.cloud) === null || _metadataInfo$cloud4 === void 0 ? void 0 : _metadataInfo$cloud4.provider,
    tooltipFieldLabel: 'cloud.provider'
  }];
};
const ecsContainerMetadataData = metadataInfo => {
  var _metadataInfo$contain2, _metadataInfo$contain3, _metadataInfo$contain4, _metadataInfo$host4;
  return [{
    field: 'containerId',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$contain2 = metadataInfo.container) === null || _metadataInfo$contain2 === void 0 ? void 0 : _metadataInfo$contain2.id,
    tooltipFieldLabel: 'container.id'
  }, {
    field: 'containerImageName',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$contain3 = metadataInfo.container) === null || _metadataInfo$contain3 === void 0 ? void 0 : (_metadataInfo$contain4 = _metadataInfo$contain3.image) === null || _metadataInfo$contain4 === void 0 ? void 0 : _metadataInfo$contain4.name,
    tooltipFieldLabel: 'container.image.name'
  }, {
    field: 'hostName',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$host4 = metadataInfo.host) === null || _metadataInfo$host4 === void 0 ? void 0 : _metadataInfo$host4.name,
    tooltipFieldLabel: 'host.name'
  }];
};
const semConvHostExtendedMetadata = metadataInfo => {
  var _metadataInfo$resourc, _metadataInfo$resourc2, _metadataInfo$resourc3, _metadataInfo$resourc4, _metadataInfo$resourc5, _metadataInfo$resourc6;
  return [{
    field: 'cloudProvider',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$resourc = metadataInfo.resource) === null || _metadataInfo$resourc === void 0 ? void 0 : (_metadataInfo$resourc2 = _metadataInfo$resourc.attributes) === null || _metadataInfo$resourc2 === void 0 ? void 0 : (_metadataInfo$resourc3 = _metadataInfo$resourc2.cloud) === null || _metadataInfo$resourc3 === void 0 ? void 0 : _metadataInfo$resourc3.provider,
    tooltipFieldLabel: 'cloud.provider',
    tooltipLink: 'https://opentelemetry.io/docs/specs/semconv/registry/attributes/cloud/#cloud-provider'
  }, {
    field: 'operatingSystem',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$resourc4 = metadataInfo.resource) === null || _metadataInfo$resourc4 === void 0 ? void 0 : (_metadataInfo$resourc5 = _metadataInfo$resourc4.attributes) === null || _metadataInfo$resourc5 === void 0 ? void 0 : (_metadataInfo$resourc6 = _metadataInfo$resourc5.os) === null || _metadataInfo$resourc6 === void 0 ? void 0 : _metadataInfo$resourc6.name,
    tooltipFieldLabel: 'os.name',
    tooltipLink: 'https://opentelemetry.io/docs/specs/semconv/registry/attributes/os/#os-name'
  }];
};
const semConvHostMetadataData = metadataInfo => {
  var _metadataInfo$resourc7, _metadataInfo$resourc8, _metadataInfo$resourc9, _metadataInfo$resourc10, _metadataInfo$resourc11, _metadataInfo$resourc12;
  return [{
    field: 'hostIp',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$resourc7 = metadataInfo.resource) === null || _metadataInfo$resourc7 === void 0 ? void 0 : (_metadataInfo$resourc8 = _metadataInfo$resourc7.attributes) === null || _metadataInfo$resourc8 === void 0 ? void 0 : (_metadataInfo$resourc9 = _metadataInfo$resourc8.host) === null || _metadataInfo$resourc9 === void 0 ? void 0 : _metadataInfo$resourc9.ip,
    tooltipFieldLabel: 'host.ip',
    tooltipLink: 'https://opentelemetry.io/docs/specs/semconv/registry/attributes/host/#host-ip'
  }, {
    field: 'hostOsVersion',
    value: metadataInfo === null || metadataInfo === void 0 ? void 0 : (_metadataInfo$resourc10 = metadataInfo.resource) === null || _metadataInfo$resourc10 === void 0 ? void 0 : (_metadataInfo$resourc11 = _metadataInfo$resourc10.attributes) === null || _metadataInfo$resourc11 === void 0 ? void 0 : (_metadataInfo$resourc12 = _metadataInfo$resourc11.os) === null || _metadataInfo$resourc12 === void 0 ? void 0 : _metadataInfo$resourc12.version,
    tooltipFieldLabel: 'os.version',
    tooltipLink: 'https://opentelemetry.io/docs/specs/semconv/registry/attributes/os/#os-version'
  }];
};
const getHostMetadataBySchema = (metadata, schema) => {
  switch (schema) {
    case 'ecs':
      return {
        metadata: ecsHostMetadataData(metadata),
        extended: ecsHostExtendedMetadata(metadata)
      };
    default:
      return {
        metadata: semConvHostMetadataData(metadata),
        extended: semConvHostExtendedMetadata(metadata)
      };
  }
};
exports.getHostMetadataBySchema = getHostMetadataBySchema;
const getContainerMetadata = metadata => {
  return {
    metadata: ecsContainerMetadataData(metadata),
    extended: ecsContainerExtendedMetadata(metadata)
  };
};
exports.getContainerMetadata = getContainerMetadata;