"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricRowWithAgg = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _metrics = require("../../../../../common/alerting/metrics");
var _metric_row_controls = require("./metric_row_controls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/metric_threshold/components/custom_equation/metric_row_with_agg.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricRowWithAgg = ({
  name,
  aggType = _metrics.Aggregators.AVERAGE,
  field,
  onDelete,
  disableDelete,
  fields,
  aggregationTypes,
  onChange,
  errors
}) => {
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(name);
  }, [name, onDelete]);
  const fieldOptions = (0, _react.useMemo)(() => fields.reduce((acc, fieldValue) => {
    if (aggType && aggregationTypes[aggType].validNormalizedTypes.includes(fieldValue.normalizedType)) {
      acc.push({
        label: fieldValue.name
      });
    }
    return acc;
  }, []), [fields, aggregationTypes, aggType]);
  const aggOptions = (0, _react.useMemo)(() => Object.values(aggregationTypes).map(a => ({
    text: a.text,
    value: a.value
  })), [aggregationTypes]);
  const handleFieldChange = (0, _react.useCallback)(selectedOptions => {
    onChange({
      name,
      field: selectedOptions.length && selectedOptions[0].label || undefined,
      aggType
    });
  }, [name, aggType, onChange]);
  const handleAggChange = (0, _react.useCallback)(el => {
    const customMetricAggType = el.target.value;
    onChange({
      name,
      field: customMetricAggType === _metrics.Aggregators.COUNT ? undefined : field,
      aggType: customMetricAggType
    });
  }, [name, field, onChange]);
  const isAggInvalid = (0, _lodash.get)(errors, ['customMetrics', name, 'aggType']) != null;
  const isFieldInvalid = (0, _lodash.get)(errors, ['customMetrics', name, 'field']) != null || !field;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: 145
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.aggregationLabel', {
      defaultMessage: 'Aggregation {name}',
      values: {
        name
      }
    }),
    isInvalid: isAggInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "infraMetricRowWithAggSelect",
    options: aggOptions,
    value: aggType,
    isInvalid: isAggInvalid,
    onChange: handleAggChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.infra.metrics.alertFlyout.customEquationEditor.fieldLabel', {
      defaultMessage: 'Field {name}',
      values: {
        name
      }
    }),
    isInvalid: isFieldInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    isInvalid: isFieldInvalid,
    singleSelection: {
      asPlainText: true
    },
    options: fieldOptions,
    selectedOptions: field ? [{
      label: field
    }] : [],
    onChange: handleFieldChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_metric_row_controls.MetricRowControls, {
    onDelete: handleDelete,
    disableDelete: disableDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }));
};
exports.MetricRowWithAgg = MetricRowWithAgg;