"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _policy_list = require("./policy_list");
var _shared_imports = require("../../../shared_imports");
var _api = require("../../services/api");
var _policy_list_context = require("./policy_list_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/policy_list.container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyList = () => {
  const {
    services: {
      breadcrumbService
    }
  } = (0, _shared_imports.useKibana)();
  const {
    data: policies,
    isLoading,
    error,
    resendRequest
  } = (0, _api.useLoadPoliciesList)();
  (0, _react.useEffect)(() => {
    breadcrumbService.setBreadcrumbs('policies');
  }, [breadcrumbService]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 16
        }
      }),
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.policiesLoading",
        defaultMessage: "Loading policies...",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 31,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    });
  }
  if (error) {
    const {
      statusCode,
      message
    } = error ? error : {
      statusCode: '',
      message: ''
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.policiesLoadingFailedTitle",
        defaultMessage: "Unable to load existing lifecycle policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 11
        }
      }, message, " (", statusCode, ")"),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resendRequest,
        iconType: "refresh",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.policyTable.policiesReloadButton",
        defaultMessage: "Try again",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_policy_list_context.PolicyListContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_list.PolicyList, {
    policies: policies || [],
    updatePolicies: resendRequest,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
};
exports.PolicyList = PolicyList;