"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HotPhase = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _i18n_texts = require("../../../i18n_texts");
var _form = require("../../../form");
var _edit_policy_context = require("../../../edit_policy_context");
var _constants = require("../../../constants");
var _ = require("../..");
var _shared_fields = require("../shared_fields");
var _phase = require("../phase");
var _use_rollover_value_required_validation = require("./use_rollover_value_required_validation");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/hot_phase/hot_phase.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const rolloverFieldPaths = Object.values(_constants.ROLLOVER_FORM_PATHS);
const HotPhase = () => {
  const {
    license
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [_constants.isUsingDefaultRolloverPath, ...rolloverFieldPaths]
  });
  const {
    isUsingRollover,
    isUsingDownsampleInHotPhase
  } = (0, _form.useConfiguration)();
  const isUsingDefaultRollover = (0, _lodash.get)(formData, _constants.isUsingDefaultRolloverPath);
  const showEmptyRolloverFieldsError = (0, _use_rollover_value_required_validation.useRolloverValueRequiredValidation)();
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_phase.Phase, {
    phase: "hot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_.DescribedFormRow, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 16
      }
    }, _i18n_texts.i18nTexts.editPolicy.rolloverLabel),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.hotPhase.rolloverDescriptionMessage",
      defaultMessage: "Start writing to a new index when the current index reaches a certain size, document count, or age. Enables you to optimize performance and manage resource usage when working with time series data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.indexLifecycleMgmt.rollover.rolloverOffsetsPhaseTimingDescriptionNote', {
      defaultMessage: 'Note: '
    })), _i18n_texts.i18nTexts.editPolicy.rolloverOffsetsHotPhaseTiming, ' ', /*#__PURE__*/_react.default.createElement(_.LearnMoreLink, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.hotPhase.learnAboutRolloverLinkText",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 21
        }
      }),
      docPath: docLinks.links.elasticsearch.ilmRollover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
      path: _constants.isUsingDefaultRolloverPath,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 13
      }
    }, field => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "default",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: field.label,
      checked: field.value,
      onChange: e => field.setValue(e.target.checked),
      "data-test-subj": "useDefaultRolloverSwitch",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.hotPhase.rolloverDefaultsTipContent",
      defaultMessage: "Roll over when an index is 30 days old or any primary shard reaches 50 gigabytes.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 19
      }
    })))),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, isUsingDefaultRollover === false ? /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    role: "region",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: "_meta.hot.customRollover.enabled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, field => /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: field.label,
    checked: field.value,
    onChange: e => field.setValue(e.target.checked),
    "data-test-subj": "rolloverSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  })), isUsingRollover && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }), showEmptyRolloverFieldsError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n_texts.i18nTexts.editPolicy.errors.rollOverConfigurationCallout.title,
    "data-test-subj": "rolloverSettingsRequired",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 23
    }
  }, _i18n_texts.i18nTexts.editPolicy.errors.rollOverConfigurationCallout.body)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_components.MaxPrimaryShardSizeField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_components.MaxPrimaryShardDocsField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_components.MaxAgeField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_components.MaxDocumentCountField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_components.MaxIndexSizeField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 17
    }
  }))) : /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  })), isUsingRollover && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_fields.ForcemergeField, {
    phase: 'hot',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 12
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.ShrinkField, {
    phase: 'hot',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }), license.canUseSearchableSnapshot() && /*#__PURE__*/_react.default.createElement(_shared_fields.SearchableSnapshotField, {
    phase: "hot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 50
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_fields.DownsampleField, {
    phase: "hot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }), !isUsingDownsampleInHotPhase && /*#__PURE__*/_react.default.createElement(_shared_fields.ReadonlyField, {
    phase: 'hot',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 44
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_fields.IndexPriorityField, {
    phase: 'hot',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }));
};
exports.HotPhase = HotPhase;