"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phase_icon/phase_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useStyles = ({
  enabled,
  phase
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isBorealis = euiTheme.themeName === 'EUI_THEME_BOREALIS';
  const phaseIconColors = {
    hot: isBorealis ? euiTheme.colors.vis.euiColorVis6 : euiTheme.colors.vis.euiColorVisBehindText9,
    warm: isBorealis ? euiTheme.colors.vis.euiColorVis9 : euiTheme.colors.vis.euiColorVisBehindText5,
    cold: isBorealis ? euiTheme.colors.vis.euiColorVis2 : euiTheme.colors.vis.euiColorVisBehindText1,
    frozen: isBorealis ? euiTheme.colors.vis.euiColorVis4 : euiTheme.colors.vis.euiColorVisBehindText4,
    delete: euiTheme.colors.darkShade
  };
  return {
    container: (0, _react2.css)`
      width: ${enabled ? euiTheme.size.xl : euiTheme.size.base};
      height: ${enabled ? euiTheme.size.xl : euiTheme.size.base};
      display: flex;
      justify-content: center;
      align-items: center;
      border-radius: 50%;
      background-color: ${phase === 'delete' ? euiTheme.colors.lightShade : euiTheme.colors.lightestShade};
      ${!enabled && `margin: ${euiTheme.size.s};`}
    `,
    icon: (0, _react2.css)`
      fill: ${phaseIconColors[phase]};
    `
  };
};
const PhaseIcon = ({
  enabled,
  phase
}) => {
  const styles = useStyles({
    enabled,
    phase
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: styles.icon,
    type: phase === 'delete' ? 'trash' : 'checkInCircleFilled',
    size: phase === 'delete' ? 'm' : 'l',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'dot',
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }));
};
exports.PhaseIcon = PhaseIcon;