"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyAgentsCell = exports.AgentsCountBreakDown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _components = require("../../../../../../components");
var _services = require("../../../../../../services");
var _hooks = require("../../../../../../hooks");
var _constants = require("../../../../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/policies/components/package_policy_agents_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddAgentButton = ({
  onAddAgent,
  canAddAgents,
  withPopover
}) => {
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(true);
  const onAddAgentCloseHelp = () => {
    setIsHelpOpen(false);
    onAddAgent();
  };
  return withPopover ? /*#__PURE__*/_react.default.createElement(_components.AddAgentHelpPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      "data-test-subj": "addAgentButton",
      onClick: onAddAgentCloseHelp,
      size: "s",
      isDisabled: !canAddAgents,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
      defaultMessage: "Add agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    })),
    isOpen: isHelpOpen,
    closePopover: () => setIsHelpOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    "data-test-subj": "addAgentButton",
    onClick: onAddAgent,
    size: "s",
    isDisabled: !canAddAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.integrationList.addAgent",
    defaultMessage: "Add agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }));
};
const PackagePolicyAgentsCell = ({
  agentPolicies,
  onAddAgent,
  hasHelpPopover = false
}) => {
  const {
    canUseMultipleAgentPolicies
  } = (0, _hooks.useMultipleAgentPolicies)();
  const agentCount = agentPolicies.reduce((acc, curr) => {
    return acc += (curr === null || curr === void 0 ? void 0 : curr.agents) || 0;
  }, 0);
  const canAddAgents = (0, _hooks.useAuthz)().fleet.addAgents;
  const canAddFleetServers = (0, _hooks.useAuthz)().fleet.addFleetServers;
  if (agentPolicies.length === 1 && agentPolicies[0].is_managed) {
    return /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentCount,
      agentPolicyId: agentPolicies[0].id,
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    });
  }

  // If multiple agent policies are supported and there are agents assigned to more than one
  if (canUseMultipleAgentPolicies && agentCount > 0 && agentPolicies.length > 1) {
    return /*#__PURE__*/_react.default.createElement(AgentsCountBreakDown, {
      agentCount: agentCount,
      agentPolicies: agentPolicies,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 12
      }
    });
  }
  const agentPolicy = agentPolicies[0];
  const canAddAgentsForPolicy = (0, _services.policyHasFleetServer)(agentPolicy) ? canAddFleetServers : canAddAgents;
  if (agentCount > 0) {
    return /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentCount,
      agentPolicyId: agentPolicy.id,
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(AddAgentButton, {
      onAddAgent: onAddAgent,
      canAddAgents: canAddAgentsForPolicy,
      withPopover: hasHelpPopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    });
  }
};
exports.PackagePolicyAgentsCell = PackagePolicyAgentsCell;
const AgentsCountBreakDown = ({
  agentPolicies,
  agentCount,
  privilegeMode
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _hooks.useAuthz)();
  const canReadAgents = authz.fleet.readAgents;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const getKuery = agentPolicyId => `${_constants.AGENTS_PREFIX}.policy_id : "${agentPolicyId}"${privilegeMode ? ` and ${privilegeMode === 'unprivileged' ? _constants.UNPRIVILEGED_AGENT_KUERY : _constants.PRIVILEGED_AGENT_KUERY}` : ''}`;
  const topFivePolicies = (0, _react.useMemo)(() => (0, _lodash.sortBy)(agentPolicies, 'agents').reverse().slice(0, 5), [agentPolicies]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "agentCountsPopover",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "data-test-subj": "agentsCountsButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 11
      }
    }, agentCount),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.fleet.agentsCountsBreakdown.popover.title', {
    defaultMessage: 'Agents breakdown'
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      minWidth: 300
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.fleet.agentsCountsBreakdown.popover.heading', {
    defaultMessage: 'Top values'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 11
    }
  }), topFivePolicies.map(agentPolicy => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: agentPolicy.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    key: agentPolicy.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 19
    }
  }, agentPolicy.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }, agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.agents && agentPolicy.agents > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: getHref('agent_list', {
      kuery: getKuery(agentPolicy.id),
      showInactive: true
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 21
    }
  }, agentPolicy.agents) : 0)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }), agentCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fullWidth: true,
    size: "s",
    "data-test-subj": "agentsCountsBreakdownPopoverButton",
    href: getHref('agent_list', {
      showInactive: true
    }),
    isDisabled: !canReadAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.fleet.agentsCountsBreakdown.popover.button', {
    defaultMessage: 'View all {agentCount, plural, one {# agent} other {# agents}}',
    values: {
      agentCount
    }
  }))) : null)));
};
exports.AgentsCountBreakDown = AgentsCountBreakDown;