"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteDownloadSource = useDeleteDownloadSource;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _use_confirm_modal = require("../../hooks/use_confirm_modal");
var _get_count = require("./services/get_count");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765022786381327106/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/download_source_flyout/use_delete_download_source.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteDowloadSource.confirmModalTitle",
  defaultMessage: "Delete and deploy changes?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
});
const ConfirmDeleteDescription = ({
  downloadSource,
  agentCount,
  agentPolicyCount
}) => agentCount !== undefined && agentPolicyCount !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteDowloadSource.confirmModalText",
  defaultMessage: "This action will delete {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",
  values: {
    downloadSourceName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 29
      }
    }, downloadSource.name),
    agents: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteDowloadSource.agentsCount",
      defaultMessage: "{agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 13
      }
    })),
    policies: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteDowloadSource.agentPolicyCount",
      defaultMessage: "{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",
      values: {
        agentPolicyCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.deleteDowloadSource.confirmModalTextWithoutCount",
  defaultMessage: "This action will delete {downloadSourceName} agent binary source and it will update its related policies and agents. This action can not be undone. Are you sure you wish to continue?",
  values: {
    downloadSourceName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 29
      }
    }, downloadSource.name)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 5
  }
});
function useDeleteDownloadSource(onSuccess) {
  const {
    confirm
  } = (0, _use_confirm_modal.useConfirmModal)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const deleteDownloadSource = (0, _react.useCallback)(async downloadSource => {
    try {
      const {
        agentCount,
        agentPolicyCount
      } = await (0, _get_count.getCountsForDownloadSource)(downloadSource
      // Fail gracefully when counts are not available
      ).catch(() => ({
        agentCount: undefined,
        agentPolicyCount: undefined
      }));
      const isConfirmed = await confirm(/*#__PURE__*/_react.default.createElement(ConfirmTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(ConfirmDeleteDescription, {
        "data-test-subj": "editDownloadSourcesDeleteModal.confirmModalText",
        downloadSource: downloadSource,
        agentCount: agentCount,
        agentPolicyCount: agentPolicyCount,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 11
        }
      }), {
        buttonColor: 'danger',
        confirmButtonText: _i18n.i18n.translate('xpack.fleet.settings.deleteDownloadSource.confirmButtonLabel', {
          defaultMessage: 'Delete and deploy'
        })
      });
      if (!isConfirmed) {
        return;
      }
      const res = await (0, _hooks.sendDeleteDownloadSource)(downloadSource.id);
      if (res.error) {
        throw res.error;
      }
      onSuccess();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.settings.deleteDownloadSource.errorToastTitle', {
          defaultMessage: 'Error deleting agent binary source.'
        })
      });
    }
  }, [confirm, notifications.toasts, onSuccess]);
  return {
    deleteDownloadSource
  };
}